/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.blocks;

import com.mojang.serialization.MapCodec;
import com.telepathicgrunt.the_bumblezone.advancements.GenericTrigger;
import com.telepathicgrunt.the_bumblezone.items.HoneyBeeLeggings;
import com.telepathicgrunt.the_bumblezone.modinit.BzCriterias;
import com.telepathicgrunt.the_bumblezone.modinit.BzSounds;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import it.unimi.dsi.fastutil.objects.Object2ShortMap;
import it.unimi.dsi.fastutil.objects.Object2ShortOpenHashMap;
import it.unimi.dsi.fastutil.shorts.Short2ObjectArrayMap;
import it.unimi.dsi.fastutil.shorts.Short2ObjectMap;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class StickyHoneyResidue
extends Block {
    public static final BooleanProperty UP = PipeBlock.UP;
    public static final BooleanProperty DOWN = PipeBlock.DOWN;
    public static final BooleanProperty WEST = PipeBlock.WEST;
    public static final BooleanProperty EAST = PipeBlock.EAST;
    public static final BooleanProperty SOUTH = PipeBlock.SOUTH;
    public static final BooleanProperty NORTH = PipeBlock.NORTH;
    private static final VoxelShape[] BASE_SHAPES_BY_DIRECTION_ORDINAL = new VoxelShape[]{Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0), Block.box((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0), Block.box((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0), Block.box((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)};
    protected final Short2ObjectMap<VoxelShape> shapeByIndex = new Short2ObjectArrayMap();
    private final Object2ShortMap<BlockState> stateToIndex = new Object2ShortOpenHashMap();
    public static final Map<Direction, BooleanProperty> FACING_TO_PROPERTY_MAP = (Map)PipeBlock.PROPERTY_BY_DIRECTION.entrySet().stream().collect(Util.toMap());
    public static final MapCodec<StickyHoneyResidue> CODEC = Block.simpleCodec(StickyHoneyResidue::new);

    public StickyHoneyResidue() {
        this(BlockBehaviour.Properties.of().mapColor(MapColor.TERRACOTTA_ORANGE).noCollission().strength(6.0f, 0.0f).noOcclusion().replaceable().pushReaction(PushReaction.DESTROY));
    }

    public StickyHoneyResidue(BlockBehaviour.Properties settings) {
        super(settings);
        for (BlockState blockState : this.stateDefinition.getPossibleStates()) {
            this.shapeByIndex.computeIfAbsent(this.getShapeIndex(blockState), bitFlag -> {
                VoxelShape shape = Shapes.empty();
                for (Direction direction : Direction.values()) {
                    if ((bitFlag >> direction.ordinal() & 1) == 0) continue;
                    shape = Shapes.joinUnoptimized((VoxelShape)shape, (VoxelShape)BASE_SHAPES_BY_DIRECTION_ORDINAL[direction.ordinal()], (BooleanOp)BooleanOp.OR);
                }
                return shape.optimize();
            });
        }
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)UP, (Comparable)Boolean.valueOf(false))).setValue((Property)NORTH, (Comparable)Boolean.valueOf(false))).setValue((Property)EAST, (Comparable)Boolean.valueOf(false))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(false))).setValue((Property)WEST, (Comparable)Boolean.valueOf(false))).setValue((Property)DOWN, (Comparable)Boolean.valueOf(false)));
    }

    public MapCodec<? extends StickyHoneyResidue> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{UP, NORTH, EAST, SOUTH, WEST, DOWN});
    }

    private static short calculateBitFlag(BlockState blockState) {
        short bitFlag = 0;
        for (Direction direction : Direction.values()) {
            if (!((Boolean)blockState.getValue((Property)FACING_TO_PROPERTY_MAP.get(direction))).booleanValue()) continue;
            bitFlag = (short)(bitFlag | 1 << direction.ordinal());
        }
        return bitFlag;
    }

    protected short getShapeIndex(BlockState blockState) {
        return this.stateToIndex.computeIfAbsent((Object)blockState, StickyHoneyResidue::calculateBitFlag);
    }

    public VoxelShape getShape(BlockState blockstate, BlockGetter world, BlockPos pos, CollisionContext context) {
        return (VoxelShape)this.shapeByIndex.getOrDefault(this.getShapeIndex(blockstate), (Object)Shapes.empty());
    }

    public boolean propagatesSkylightDown(BlockState p_181239_, BlockGetter p_181240_, BlockPos p_181241_) {
        return true;
    }

    public static boolean isAcceptableNeighbour(BlockGetter p_57854_, BlockPos p_57855_, Direction p_57856_) {
        BlockState blockstate = p_57854_.getBlockState(p_57855_);
        return Block.isFaceFull((VoxelShape)blockstate.getCollisionShape(p_57854_, p_57855_), (Direction)p_57856_.getOpposite());
    }

    private int countFaces(BlockState blockState) {
        int i = 0;
        for (BooleanProperty booleanproperty : FACING_TO_PROPERTY_MAP.values()) {
            if (!((Boolean)blockState.getValue((Property)booleanproperty)).booleanValue()) continue;
            ++i;
        }
        return i;
    }

    public boolean canBeReplaced(BlockState blockState, BlockPlaceContext blockPlaceContext) {
        BlockState blockstate = blockPlaceContext.getLevel().getBlockState(blockPlaceContext.getClickedPos());
        if (blockstate.is((Block)this)) {
            return this.countFaces(blockstate) < FACING_TO_PROPERTY_MAP.size();
        }
        return super.canBeReplaced(blockState, blockPlaceContext);
    }

    @Deprecated
    public void entityInside(BlockState blockState, Level level, BlockPos blockPos, Entity entity) {
        ItemStack beeLeggings;
        if (entity.getType().is(BzTags.STICKY_HONEY_RESIDUE_CANNOT_SLOW)) {
            super.entityInside(blockState, level, blockPos, entity);
            return;
        }
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            v0 = HoneyBeeLeggings.getEntityBeeLegging(livingEntity);
        } else {
            v0 = beeLeggings = ItemStack.EMPTY;
        }
        if (!beeLeggings.isEmpty()) {
            super.entityInside(blockState, level, blockPos, entity);
            return;
        }
        VoxelShape voxelShape = this.getShape(blockState, (BlockGetter)level, blockPos, null);
        AABB entityBounds = entity.getBoundingBox().move((double)(-blockPos.getX()), (double)(-blockPos.getY()), (double)(-blockPos.getZ()));
        if (Shapes.joinIsNotEmpty((VoxelShape)Shapes.create((AABB)entityBounds), (VoxelShape)voxelShape, (BooleanOp)BooleanOp.AND)) {
            entity.makeStuckInBlock(blockState, new Vec3(0.35, (double)0.2f, 0.35));
            if (entity instanceof LivingEntity) {
                Player player;
                LivingEntity livingEntity = (LivingEntity)entity;
                if (!(entity instanceof Player) || !(player = (Player)entity).isCreative()) {
                    livingEntity.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 200, 1, false, false, true));
                }
            }
        }
        super.entityInside(blockState, level, blockPos, entity);
    }

    public boolean canSurvive(BlockState blockstate, LevelReader world, BlockPos pos) {
        return StickyHoneyResidue.hasAtleastOneAttachment(this.setAttachments(blockstate, world, pos));
    }

    public static boolean hasAtleastOneAttachment(BlockState blockstate) {
        return StickyHoneyResidue.numberOfAttachments(blockstate) > 0;
    }

    private static int numberOfAttachments(BlockState blockstate) {
        int i = 0;
        for (BooleanProperty booleanproperty : FACING_TO_PROPERTY_MAP.values()) {
            if (!((Boolean)blockstate.getValue((Property)booleanproperty)).booleanValue()) continue;
            ++i;
        }
        return i;
    }

    private BlockState setAttachments(BlockState blockstate, LevelReader blockReader, BlockPos pos) {
        for (Direction direction : Direction.values()) {
            BooleanProperty booleanproperty = FACING_TO_PROPERTY_MAP.get(direction);
            if (!((Boolean)blockstate.getValue((Property)booleanproperty)).booleanValue()) continue;
            boolean flag = StickyHoneyResidue.isAcceptableNeighbour((BlockGetter)blockReader, pos.relative(direction), direction);
            blockstate = (BlockState)blockstate.setValue((Property)booleanproperty, (Comparable)Boolean.valueOf(flag));
        }
        return blockstate;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState currentBlockstate = context.getLevel().getBlockState(context.getClickedPos());
        boolean isSameBlock = currentBlockstate.getBlock() == this;
        BlockState newBlockstate = isSameBlock ? currentBlockstate : this.defaultBlockState();
        for (Direction direction : context.getNearestLookingDirections()) {
            boolean faceIsAlreadyTrue;
            BooleanProperty booleanproperty = FACING_TO_PROPERTY_MAP.get(direction);
            boolean bl = faceIsAlreadyTrue = isSameBlock && (Boolean)currentBlockstate.getValue((Property)booleanproperty) != false;
            if (faceIsAlreadyTrue || !VineBlock.isAcceptableNeighbour((BlockGetter)context.getLevel(), (BlockPos)context.getClickedPos().relative(direction), (Direction)direction)) continue;
            return (BlockState)newBlockstate.setValue((Property)booleanproperty, (Comparable)Boolean.valueOf(true));
        }
        return isSameBlock ? newBlockstate : null;
    }

    public BlockState updateShape(BlockState blockstate, Direction facing, BlockState facingState, LevelAccessor world, BlockPos currentPos, BlockPos facingPos) {
        BlockState newBlockstate = this.setAttachments(blockstate, (LevelReader)world, currentPos);
        return !StickyHoneyResidue.hasAtleastOneAttachment(newBlockstate) ? Blocks.AIR.defaultBlockState() : newBlockstate;
    }

    public void tick(BlockState blockstate, ServerLevel world, BlockPos currentPos, RandomSource random) {
        super.tick(blockstate, world, currentPos, random);
        BlockState newBlockstate = this.setAttachments(blockstate, (LevelReader)world, currentPos);
        world.setBlock(currentPos, newBlockstate, 3);
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState blockstate, Level world, BlockPos pos) {
        return StickyHoneyResidue.numberOfAttachments(blockstate);
    }

    public int getLightBlock(BlockState state, BlockGetter world, BlockPos pos) {
        return 1;
    }

    public ItemInteractionResult useItemOn(ItemStack itemStack, BlockState blockState, Level level, BlockPos position, Player playerEntity, InteractionHand playerHand, BlockHitResult raytraceResult) {
        if (itemStack.is(BzTags.WASHING_ITEMS) && (!itemStack.is(Items.POTION) || itemStack.getComponents().has(DataComponents.POTION_CONTENTS) && ((PotionContents)itemStack.getComponents().get(DataComponents.POTION_CONTENTS)).is(Potions.WATER))) {
            ServerPlayer serverPlayer;
            if (!itemStack.isEmpty()) {
                playerEntity.awardStat(Stats.ITEM_USED.get((Object)itemStack.getItem()));
            }
            if (playerEntity instanceof ServerPlayer) {
                serverPlayer = (ServerPlayer)playerEntity;
                ((GenericTrigger)((Object)BzCriterias.CLEANUP_STICKY_HONEY_RESIDUE_TRIGGER.get())).trigger(serverPlayer);
            }
            level.destroyBlock(position, false);
            level.playSound(playerEntity, playerEntity.getX(), playerEntity.getY(), playerEntity.getZ(), (SoundEvent)BzSounds.WASHING_RESIDUES.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            if (playerEntity instanceof ServerPlayer) {
                serverPlayer = (ServerPlayer)playerEntity;
                if (((Boolean)blockState.getValue((Property)UP)).booleanValue()) {
                    ((ServerLevel)level).sendParticles(serverPlayer, (ParticleOptions)ParticleTypes.FALLING_WATER, true, (double)position.getX() + 0.5, (double)position.getY() + 0.95, (double)position.getZ() + 0.5, 6, 0.3, 0.0, 0.3, 1.0);
                }
                if (((Boolean)blockState.getValue((Property)NORTH)).booleanValue()) {
                    ((ServerLevel)level).sendParticles(serverPlayer, (ParticleOptions)ParticleTypes.FALLING_WATER, true, (double)position.getX() + 0.5, (double)position.getY() + 0.5, (double)position.getZ() + 0.05, 6, 0.3, 0.3, 0.0, 1.0);
                }
                if (((Boolean)blockState.getValue((Property)EAST)).booleanValue()) {
                    ((ServerLevel)level).sendParticles(serverPlayer, (ParticleOptions)ParticleTypes.FALLING_WATER, true, (double)position.getX() + 0.95, (double)position.getY() + 0.5, (double)position.getZ() + 0.5, 6, 0.0, 0.3, 0.3, 1.0);
                }
                if (((Boolean)blockState.getValue((Property)SOUTH)).booleanValue()) {
                    ((ServerLevel)level).sendParticles(serverPlayer, (ParticleOptions)ParticleTypes.FALLING_WATER, true, (double)position.getX() + 0.5, (double)position.getY() + 0.5, (double)position.getZ() + 0.95, 6, 0.3, 0.3, 0.0, 1.0);
                }
                if (((Boolean)blockState.getValue((Property)WEST)).booleanValue()) {
                    ((ServerLevel)level).sendParticles(serverPlayer, (ParticleOptions)ParticleTypes.FALLING_WATER, true, (double)position.getX() + 0.05, (double)position.getY() + 0.5, (double)position.getZ() + 0.5, 6, 0.0, 0.3, 0.3, 1.0);
                }
                if (((Boolean)blockState.getValue((Property)DOWN)).booleanValue()) {
                    ((ServerLevel)level).sendParticles(serverPlayer, (ParticleOptions)ParticleTypes.FALLING_WATER, true, (double)position.getX() + 0.5, (double)position.getY() + 0.05, (double)position.getZ() + 0.5, 6, 0.3, 0.0, 0.3, 1.0);
                }
            }
            return ItemInteractionResult.SUCCESS;
        }
        return super.useItemOn(itemStack, blockState, level, position, playerEntity, playerHand, raytraceResult);
    }

    public BlockState rotate(BlockState blockState, Rotation rotation) {
        return switch (rotation) {
            case Rotation.CLOCKWISE_180 -> (BlockState)((BlockState)((BlockState)((BlockState)blockState.setValue((Property)NORTH, (Comparable)((Boolean)blockState.getValue((Property)SOUTH)))).setValue((Property)EAST, (Comparable)((Boolean)blockState.getValue((Property)WEST)))).setValue((Property)SOUTH, (Comparable)((Boolean)blockState.getValue((Property)NORTH)))).setValue((Property)WEST, (Comparable)((Boolean)blockState.getValue((Property)EAST)));
            case Rotation.COUNTERCLOCKWISE_90 -> (BlockState)((BlockState)((BlockState)((BlockState)blockState.setValue((Property)NORTH, (Comparable)((Boolean)blockState.getValue((Property)EAST)))).setValue((Property)EAST, (Comparable)((Boolean)blockState.getValue((Property)SOUTH)))).setValue((Property)SOUTH, (Comparable)((Boolean)blockState.getValue((Property)WEST)))).setValue((Property)WEST, (Comparable)((Boolean)blockState.getValue((Property)NORTH)));
            case Rotation.CLOCKWISE_90 -> (BlockState)((BlockState)((BlockState)((BlockState)blockState.setValue((Property)NORTH, (Comparable)((Boolean)blockState.getValue((Property)WEST)))).setValue((Property)EAST, (Comparable)((Boolean)blockState.getValue((Property)NORTH)))).setValue((Property)SOUTH, (Comparable)((Boolean)blockState.getValue((Property)EAST)))).setValue((Property)WEST, (Comparable)((Boolean)blockState.getValue((Property)SOUTH)));
            default -> blockState;
        };
    }

    public BlockState mirror(BlockState blockState, Mirror mirror) {
        return switch (mirror) {
            case Mirror.LEFT_RIGHT -> (BlockState)((BlockState)blockState.setValue((Property)NORTH, (Comparable)((Boolean)blockState.getValue((Property)SOUTH)))).setValue((Property)SOUTH, (Comparable)((Boolean)blockState.getValue((Property)NORTH)));
            case Mirror.FRONT_BACK -> (BlockState)((BlockState)blockState.setValue((Property)EAST, (Comparable)((Boolean)blockState.getValue((Property)WEST)))).setValue((Property)WEST, (Comparable)((Boolean)blockState.getValue((Property)EAST)));
            default -> super.mirror(blockState, mirror);
        };
    }

    public void animateTick(BlockState blockState, Level world, BlockPos position, RandomSource random) {
        for (int i = 0; i == random.nextInt(50); ++i) {
            Direction randomDirection = Direction.values()[random.nextInt(Direction.values().length)];
            if (randomDirection == Direction.DOWN) continue;
            this.addParticle((ParticleOptions)ParticleTypes.DRIPPING_HONEY, random, world, position, blockState, randomDirection);
        }
    }

    protected void addParticle(ParticleOptions particleType, RandomSource random, Level world, BlockPos blockPos, BlockState blockState, Direction direction) {
        short bitFlag = this.getShapeIndex(blockState);
        if ((bitFlag >> direction.ordinal() & 1) != 0) {
            VoxelShape chosenSide = BASE_SHAPES_BY_DIRECTION_ORDINAL[direction.ordinal()];
            this.addParticle(particleType, world, random, (double)blockPos.getX() + chosenSide.min(Direction.Axis.X), (double)blockPos.getX() + chosenSide.max(Direction.Axis.X), (double)blockPos.getY() + chosenSide.min(Direction.Axis.Y), (double)blockPos.getY() + chosenSide.max(Direction.Axis.Y), (double)blockPos.getZ() + chosenSide.min(Direction.Axis.Z), (double)blockPos.getZ() + chosenSide.max(Direction.Axis.Z));
        }
    }

    private void addParticle(ParticleOptions particleType, Level world, RandomSource random, double xMin, double xMax, double yMin, double yMax, double zMax, double zMin) {
        world.addParticle(particleType, Mth.lerp((double)random.nextDouble(), (double)xMin, (double)xMax), Mth.lerp((double)random.nextDouble(), (double)yMin, (double)yMax), Mth.lerp((double)random.nextDouble(), (double)zMin, (double)zMax), 0.0, 0.0, 0.0);
    }
}

