/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.blocks;

import com.mojang.serialization.MapCodec;
import com.telepathicgrunt.the_bumblezone.blocks.blockentities.InfinityBarrierBlockEntity;
import com.telepathicgrunt.the_bumblezone.events.player.PlayerItemUseOnBlockEvent;
import com.telepathicgrunt.the_bumblezone.modinit.BzBlockEntities;
import com.telepathicgrunt.the_bumblezone.modinit.BzBlocks;
import com.telepathicgrunt.the_bumblezone.modinit.BzDamageSources;
import com.telepathicgrunt.the_bumblezone.platform.BlockExtension;
import com.telepathicgrunt.the_bumblezone.utils.OptionalBoolean;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.HangingEntityItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import org.jetbrains.annotations.Nullable;

public class InfinityBarrier
extends BaseEntityBlock
implements BlockExtension {
    public static final MapCodec<InfinityBarrier> CODEC = Block.simpleCodec(InfinityBarrier::new);

    public InfinityBarrier() {
        this(BlockBehaviour.Properties.of().mapColor(MapColor.NONE).strength(-1.0f, 3600000.8f).lightLevel(blockState -> 15).noLootTable().noTerrainParticles().isValidSpawn((blockState, blockGetter, blockPos, entityType) -> false).pushReaction(PushReaction.BLOCK));
    }

    public InfinityBarrier(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public MapCodec<? extends InfinityBarrier> codec() {
        return CODEC;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return ((BlockEntityType)BzBlockEntities.INFINITY_BARRIER.get()).create(blockPos, blockState);
    }

    public RenderShape getRenderShape(BlockState arg) {
        return RenderShape.MODEL;
    }

    public void playerDestroy(Level level, Player player, BlockPos blockPos, BlockState blockState, @Nullable BlockEntity blockEntity, ItemStack itemStack) {
        if (level instanceof ServerLevel && !player.isCreative()) {
            player.hurt(level.damageSources().source(BzDamageSources.ARCHITECTS_TYPE), Math.max(player.getHealth(), player.getMaxHealth()) / 2.0f);
        }
    }

    public void destroy(LevelAccessor level, BlockPos blockPos, BlockState blockState) {
        level.setBlock(blockPos, ((Block)BzBlocks.INFINITY_BARRIER.get()).defaultBlockState(), 3);
        BlockEntity blockEntity2 = level.getBlockEntity(blockPos);
        if (blockEntity2 instanceof InfinityBarrierBlockEntity) {
            InfinityBarrierBlockEntity infinityBarrierBlockEntity = (InfinityBarrierBlockEntity)blockEntity2;
            infinityBarrierBlockEntity.setPrimaryColor(0x3D3D3D);
            infinityBarrierBlockEntity.setSecondaryColor(0x161616);
        }
    }

    public float getDestroyProgress(BlockState blockState, Player player, BlockGetter blockGetter, BlockPos blockPos) {
        return 0.0f;
    }

    protected void spawnDestroyParticles(Level level, Player player, BlockPos blockPos, BlockState blockState) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (player != null) {
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.CRIT, player.getX(), player.getEyeY(), player.getZ(), 25, player.getRandom().nextGaussian() * 0.2, player.getRandom().nextGaussian() * 0.25 + 0.1, player.getRandom().nextGaussian() * 0.2, (double)0.2f);
            }
        }
    }

    @Override
    public OptionalBoolean bz$shouldNotDisplayFluidOverlay() {
        return OptionalBoolean.TRUE;
    }

    public static InteractionResult onBlockInteractEvent(PlayerItemUseOnBlockEvent event) {
        Player player = event.user();
        InteractionHand interactionHand = event.hand();
        BlockState blockState = event.level().getBlockState(event.hitResult().getBlockPos());
        if (player != null && blockState.is((Block)BzBlocks.INFINITY_BARRIER.get())) {
            ItemStack itemStack = player.getItemInHand(interactionHand);
            Item item = itemStack.getItem();
            if (item instanceof BlockItem) {
                return InteractionResult.FAIL;
            }
            if (item instanceof BucketItem) {
                return InteractionResult.FAIL;
            }
            if (item instanceof HangingEntityItem) {
                return InteractionResult.FAIL;
            }
        }
        return null;
    }
}

