/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.blocks;

import com.mojang.serialization.MapCodec;
import com.telepathicgrunt.the_bumblezone.advancements.BlockStateSpecificTrigger;
import com.telepathicgrunt.the_bumblezone.blocks.ProperFacingBlock;
import com.telepathicgrunt.the_bumblezone.modinit.BzBlocks;
import com.telepathicgrunt.the_bumblezone.modinit.BzCriterias;
import com.telepathicgrunt.the_bumblezone.modinit.BzItems;
import com.telepathicgrunt.the_bumblezone.utils.PlatformHooks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;

public class CarvableWax
extends ProperFacingBlock {
    public static final EnumProperty<Carving> CARVING = EnumProperty.create((String)"carving", Carving.class);
    public static final MapCodec<CarvableWax> CODEC = Block.simpleCodec(CarvableWax::new);
    private Item item;

    public CarvableWax() {
        this(BlockBehaviour.Properties.of().mapColor(MapColor.SAND).instrument(NoteBlockInstrument.FLUTE).strength(0.28f, 0.28f).sound(SoundType.WOOD));
    }

    public CarvableWax(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue(CARVING, (Comparable)((Object)Carving.UNCARVED)));
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.UP));
    }

    public MapCodec<? extends CarvableWax> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[0]).add(new Property[]{CARVING});
        builder.add(new Property[0]).add(new Property[]{FACING});
    }

    public Item asItem() {
        if (this.item == null) {
            this.item = (Item)BzItems.CARVABLE_WAX.get();
        }
        return this.item;
    }

    public ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state) {
        if (state.hasProperty(CARVING)) {
            Carving pattern = (Carving)((Object)state.getValue(CARVING));
            switch (pattern.ordinal()) {
                case 0: {
                    return ((Item)BzItems.CARVABLE_WAX.get()).getDefaultInstance();
                }
                case 5: {
                    return ((Item)BzItems.CARVABLE_WAX_BRICKS.get()).getDefaultInstance();
                }
                case 6: {
                    return ((Item)BzItems.CARVABLE_WAX_CHAINS.get()).getDefaultInstance();
                }
                case 4: {
                    return ((Item)BzItems.CARVABLE_WAX_DIAMOND.get()).getDefaultInstance();
                }
                case 3: {
                    return ((Item)BzItems.CARVABLE_WAX_CHISELED.get()).getDefaultInstance();
                }
                case 2: {
                    return ((Item)BzItems.CARVABLE_WAX_FLOWER.get()).getDefaultInstance();
                }
                case 1: {
                    return ((Item)BzItems.CARVABLE_WAX_WAVY.get()).getDefaultInstance();
                }
                case 7: {
                    return ((Item)BzItems.CARVABLE_WAX_MUSIC.get()).getDefaultInstance();
                }
                case 8: {
                    return ((Item)BzItems.CARVABLE_WAX_GRATE.get()).getDefaultInstance();
                }
            }
        }
        return new ItemStack((ItemLike)this);
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getNearestLookingDirection().getOpposite());
    }

    public static BlockState getFacingStateForPlacement(BlockState carvableWaxBlockState, BlockPlaceContext context) {
        return (BlockState)carvableWaxBlockState.setValue((Property)FACING, (Comparable)context.getNearestLookingDirection().getOpposite());
    }

    public ItemInteractionResult useItemOn(ItemStack itemStack, BlockState blockState, Level level, BlockPos position, Player playerEntity, InteractionHand playerHand, BlockHitResult raytraceResult) {
        if (blockState.hasProperty(CARVING) && (PlatformHooks.isToolAction(itemStack, ShearsItem.class, "shears_carve") || PlatformHooks.isToolAction(itemStack, SwordItem.class, "sword_dig"))) {
            level.setBlock(position, (BlockState)((Block)BzBlocks.CARVABLE_WAX.get()).defaultBlockState().setValue(CARVING, (Comparable)((Object)((Carving)((Object)blockState.getValue(CARVING))).next())), 3);
            this.spawnDestroyParticles(level, playerEntity, position, blockState);
            playerEntity.awardStat(Stats.ITEM_USED.get((Object)itemStack.getItem()));
            if (playerEntity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)playerEntity;
                ((BlockStateSpecificTrigger)((Object)BzCriterias.CARVE_WAX_TRIGGER.get())).trigger(serverPlayer, position);
                if (!serverPlayer.getAbilities().instabuild) {
                    itemStack.hurtAndBreak(1, (LivingEntity)serverPlayer, playerHand == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND);
                }
            }
            return ItemInteractionResult.SUCCESS;
        }
        return super.useItemOn(itemStack, blockState, level, position, playerEntity, playerHand, raytraceResult);
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState blockState, Level worldIn, BlockPos pos) {
        return Math.min(((Carving)((Object)blockState.getValue(CARVING))).ordinal(), 15);
    }

    public static enum Carving implements StringRepresentable
    {
        UNCARVED("uncarved"),
        WAVY("wavy"),
        FLOWER("flower"),
        CHISELED("chiseled"),
        DIAMOND("diamond"),
        BRICKS("bricks"),
        CHAINS("chains"),
        MUSIC("music"),
        GRATE("grate");

        private final String name;
        private static final Carving[] values;

        private Carving(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public String getSerializedName() {
            return this.name;
        }

        public Carving next() {
            return values[(this.ordinal() + 1) % values.length];
        }

        static {
            values = Carving.values();
        }
    }
}

