/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.blocks;

import com.mojang.serialization.MapCodec;
import com.telepathicgrunt.the_bumblezone.advancements.BlockStateSpecificTrigger;
import com.telepathicgrunt.the_bumblezone.blocks.AncientWaxBase;
import com.telepathicgrunt.the_bumblezone.modinit.BzCriterias;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import com.telepathicgrunt.the_bumblezone.utils.PlatformHooks;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;

public class AncientWaxSlab
extends SlabBlock
implements AncientWaxBase {
    public static final MapCodec<AncientWaxSlab> CODEC = Block.simpleCodec(AncientWaxSlab::new);

    public AncientWaxSlab() {
        this(BlockBehaviour.Properties.of().mapColor(MapColor.TERRACOTTA_BROWN).instrument(NoteBlockInstrument.BASS).strength(3.0f, 19.0f));
    }

    public AncientWaxSlab(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public MapCodec<? extends AncientWaxSlab> codec() {
        return CODEC;
    }

    public void stepOn(Level level, BlockPos blockPos, BlockState state, Entity entity) {
        this.applyEntityEffects(state, entity);
        super.stepOn(level, blockPos, state, entity);
    }

    public ItemInteractionResult useItemOn(ItemStack itemStack, BlockState blockState, Level level, BlockPos position, Player playerEntity, InteractionHand playerHand, BlockHitResult raytraceResult) {
        ItemInteractionResult result;
        if ((PlatformHooks.isToolAction(itemStack, ShearsItem.class, "shears_carve") || PlatformHooks.isToolAction(itemStack, SwordItem.class, "sword_dig")) && (result = this.swapBlocks(level, blockState, position, BzTags.ANCIENT_WAX_SLABS)) == ItemInteractionResult.SUCCESS) {
            this.spawnDestroyParticles(level, playerEntity, position, blockState);
            playerEntity.awardStat(Stats.ITEM_USED.get((Object)itemStack.getItem()));
            if (playerEntity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)playerEntity;
                ((BlockStateSpecificTrigger)((Object)BzCriterias.CARVE_WAX_TRIGGER.get())).trigger(serverPlayer, position);
                if (!serverPlayer.getAbilities().instabuild) {
                    itemStack.hurtAndBreak(1, (LivingEntity)serverPlayer, playerHand == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND);
                }
            }
            return result;
        }
        return super.useItemOn(itemStack, blockState, level, position, playerEntity, playerHand, raytraceResult);
    }
}

