/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.laserio.common.network.handler;

import com.direwolf20.laserio.common.containers.CardChemicalContainer;
import com.direwolf20.laserio.common.containers.CardEnergyContainer;
import com.direwolf20.laserio.common.containers.CardFluidContainer;
import com.direwolf20.laserio.common.containers.CardItemContainer;
import com.direwolf20.laserio.common.containers.CardRedstoneContainer;
import com.direwolf20.laserio.common.containers.LaserNodeContainer;
import com.direwolf20.laserio.common.containers.customhandler.CardItemHandler;
import com.direwolf20.laserio.common.items.cards.BaseCard;
import com.direwolf20.laserio.common.items.cards.CardEnergy;
import com.direwolf20.laserio.common.items.cards.CardFluid;
import com.direwolf20.laserio.common.items.cards.CardItem;
import com.direwolf20.laserio.common.items.cards.CardRedstone;
import com.direwolf20.laserio.common.items.filters.BaseFilter;
import com.direwolf20.laserio.common.network.data.OpenCardPayload;
import com.direwolf20.laserio.common.network.handler.PacketOpenFilter;
import com.direwolf20.laserio.integration.mekanism.CardChemical;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class PacketOpenCard {
    public static final PacketOpenCard INSTANCE = new PacketOpenCard();

    public static PacketOpenCard get() {
        return INSTANCE;
    }

    public void handle(final OpenCardPayload payload, IPayloadContext context) {
        context.enqueueWork(() -> {
            final Player sender = context.player();
            AbstractContainerMenu container = sender.containerMenu;
            if (container == null) {
                return;
            }
            Slot slot = (Slot)container.slots.get(payload.slotNumber());
            final ItemStack itemStack = slot.getItem();
            CardItemHandler handler = BaseCard.getInventory(itemStack);
            byte sideTemp = -1;
            if (container instanceof LaserNodeContainer) {
                LaserNodeContainer laserNodeContainer = (LaserNodeContainer)container;
                sideTemp = laserNodeContainer.side;
            }
            final byte side = sideTemp;
            if (itemStack.getItem() instanceof CardItem) {
                if (!payload.hasShiftDown()) {
                    MenuProvider containerProvider = new MenuProvider(){

                        public Component getDisplayName() {
                            return Component.translatable((String)"screen.laserio.lasernode");
                        }

                        public boolean shouldTriggerClientSideContainerClosingOnOpen() {
                            return false;
                        }

                        public AbstractContainerMenu createMenu(int windowId, Inventory playerInventory, Player playerEntity) {
                            return new CardItemContainer(windowId, playerInventory, sender, payload.sourcePos(), itemStack, side);
                        }
                    };
                    sender.openMenu(containerProvider, buf -> {
                        ItemStack.OPTIONAL_STREAM_CODEC.encode(buf, (Object)itemStack);
                        buf.writeByte(side);
                    });
                } else {
                    ItemStack filterItem = handler.getStackInSlot(0);
                    if (filterItem.getItem() instanceof BaseFilter) {
                        PacketOpenFilter.doOpenFilter(filterItem, itemStack, (ServerPlayer)sender, payload.sourcePos());
                    }
                }
            } else if (itemStack.getItem() instanceof CardFluid) {
                if (!payload.hasShiftDown()) {
                    MenuProvider containerProvider = new MenuProvider(){

                        public Component getDisplayName() {
                            return Component.translatable((String)"screen.laserio.lasernode");
                        }

                        public boolean shouldTriggerClientSideContainerClosingOnOpen() {
                            return false;
                        }

                        public AbstractContainerMenu createMenu(int windowId, Inventory playerInventory, Player playerEntity) {
                            return new CardFluidContainer(windowId, playerInventory, sender, payload.sourcePos(), itemStack, side);
                        }
                    };
                    sender.openMenu(containerProvider, buf -> {
                        ItemStack.OPTIONAL_STREAM_CODEC.encode(buf, (Object)itemStack);
                        buf.writeByte(side);
                    });
                } else {
                    ItemStack filterItem = handler.getStackInSlot(0);
                    if (filterItem.getItem() instanceof BaseFilter) {
                        PacketOpenFilter.doOpenFilter(filterItem, itemStack, (ServerPlayer)sender, payload.sourcePos());
                    }
                }
            } else if (itemStack.getItem() instanceof CardEnergy) {
                MenuProvider containerProvider = new MenuProvider(){

                    public Component getDisplayName() {
                        return Component.translatable((String)"screen.laserio.lasernode");
                    }

                    public boolean shouldTriggerClientSideContainerClosingOnOpen() {
                        return false;
                    }

                    public AbstractContainerMenu createMenu(int windowId, Inventory playerInventory, Player playerEntity) {
                        return new CardEnergyContainer(windowId, playerInventory, sender, payload.sourcePos(), itemStack, side);
                    }
                };
                sender.openMenu(containerProvider, buf -> {
                    ItemStack.OPTIONAL_STREAM_CODEC.encode(buf, (Object)itemStack);
                    buf.writeByte(side);
                });
            } else if (itemStack.getItem() instanceof CardRedstone) {
                MenuProvider containerProvider = new MenuProvider(){

                    public Component getDisplayName() {
                        return Component.translatable((String)"screen.laserio.lasernode");
                    }

                    public boolean shouldTriggerClientSideContainerClosingOnOpen() {
                        return false;
                    }

                    public AbstractContainerMenu createMenu(int windowId, Inventory playerInventory, Player playerEntity) {
                        return new CardRedstoneContainer(windowId, playerInventory, sender, payload.sourcePos(), itemStack, side);
                    }
                };
                sender.openMenu(containerProvider, buf -> {
                    ItemStack.OPTIONAL_STREAM_CODEC.encode(buf, (Object)itemStack);
                    buf.writeByte(side);
                });
            } else if (itemStack.getItem() instanceof CardChemical) {
                if (!payload.hasShiftDown()) {
                    MenuProvider containerProvider = new MenuProvider(){

                        public Component getDisplayName() {
                            return Component.translatable((String)"screen.laserio.lasernode");
                        }

                        public boolean shouldTriggerClientSideContainerClosingOnOpen() {
                            return false;
                        }

                        public AbstractContainerMenu createMenu(int windowId, Inventory playerInventory, Player playerEntity) {
                            return new CardChemicalContainer(windowId, playerInventory, sender, payload.sourcePos(), itemStack, side);
                        }
                    };
                    sender.openMenu(containerProvider, buf -> {
                        ItemStack.OPTIONAL_STREAM_CODEC.encode(buf, (Object)itemStack);
                        buf.writeByte(side);
                    });
                } else {
                    ItemStack filterItem = handler.getStackInSlot(0);
                    if (filterItem.getItem() instanceof BaseFilter) {
                        PacketOpenFilter.doOpenFilter(filterItem, itemStack, (ServerPlayer)sender, payload.sourcePos());
                    }
                }
            }
        });
    }
}

