/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.laserio.common.items.cards;

import com.direwolf20.laserio.client.blockentityrenders.LaserNodeBERender;
import com.direwolf20.laserio.common.containers.customhandler.CardItemHandler;
import com.direwolf20.laserio.common.containers.customhandler.DireItemContainerContents;
import com.direwolf20.laserio.setup.LaserIODataComponents;
import com.direwolf20.laserio.util.MiscTools;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class BaseCard
extends Item {
    protected CardType CARDTYPE;

    public BaseCard() {
        super(new Item.Properties().stacksTo(1));
    }

    public CardType getCardType() {
        return this.CARDTYPE;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flagIn) {
        super.appendHoverText(stack, context, tooltip, flagIn);
        Minecraft mc = Minecraft.getInstance();
        if (mc.level == null || mc.player == null) {
            return;
        }
        boolean sneakPressed = Screen.hasShiftDown();
        if (!sneakPressed) {
            tooltip.add((Component)Component.translatable((String)"laserio.tooltip.item.show_settings").withStyle(ChatFormatting.GRAY));
        } else {
            String currentMode = BaseCard.getNamedTransferMode(stack).toString();
            MutableComponent toWrite = MiscTools.tooltipMaker("laserio.tooltip.item.card.mode", ChatFormatting.GRAY.getColor());
            int modeColor = ChatFormatting.GRAY.getColor();
            if (currentMode.equals("EXTRACT")) {
                modeColor = ChatFormatting.RED.getColor();
            } else if (currentMode.equals("INSERT")) {
                modeColor = ChatFormatting.GREEN.getColor();
            } else if (currentMode.equals("STOCK")) {
                modeColor = ChatFormatting.BLUE.getColor();
            } else if (currentMode.equals("SENSOR")) {
                modeColor = ChatFormatting.YELLOW.getColor();
            }
            toWrite.append((Component)MiscTools.tooltipMaker("laserio.tooltip.item.card.mode." + currentMode, modeColor));
            tooltip.add((Component)toWrite);
            toWrite = MiscTools.tooltipMaker("laserio.tooltip.item.card.channel", ChatFormatting.GRAY.getColor());
            byte channel = BaseCard.getChannel(stack);
            toWrite.append((Component)MiscTools.tooltipMaker(String.valueOf(channel), LaserNodeBERender.colors[channel].getRGB()));
            tooltip.add((Component)toWrite);
            byte sneakyMode = BaseCard.getSneaky(stack);
            if (sneakyMode != -1) {
                toWrite = MiscTools.tooltipMaker("laserio.tooltip.item.card.sneaky", ChatFormatting.GRAY.getColor());
                toWrite.append((Component)MiscTools.tooltipMaker("laserio.tooltip.item.card.sneaky." + Direction.values()[sneakyMode].toString().toUpperCase(Locale.ROOT), ChatFormatting.DARK_GREEN.getColor()));
                tooltip.add((Component)toWrite);
            }
        }
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    public NonNullList<ItemStack> getContainerItems(ItemStack itemStack) {
        NonNullList nonnulllist = NonNullList.withSize((int)2, (Object)ItemStack.EMPTY);
        nonnulllist.set(0, (Object)BaseCard.getInventory(itemStack).getStackInSlot(0));
        nonnulllist.set(1, (Object)BaseCard.getInventory(itemStack).getStackInSlot(1));
        return nonnulllist;
    }

    public ItemStack getCraftingRemainingItem(ItemStack itemStack) {
        return ItemStack.EMPTY;
    }

    public boolean hasCraftingRemainingItem(ItemStack stack) {
        return !BaseCard.getInventory(stack).getStackInSlot(0).isEmpty() || !BaseCard.getInventory(stack).getStackInSlot(1).isEmpty();
    }

    public static CardItemHandler getInventory(ItemStack stack) {
        CardItemHandler cardItemHandler = new CardItemHandler(2, stack);
        return cardItemHandler;
    }

    public static CardItemHandler setInventory(ItemStack stack, CardItemHandler handler) {
        ArrayList<ItemStack> stacklist = new ArrayList<ItemStack>();
        for (int i = 0; i < handler.getSlots(); ++i) {
            stacklist.add(handler.getStackInSlot(i));
        }
        stack.set(LaserIODataComponents.ITEMSTACK_HANDLER, (Object)DireItemContainerContents.fromItems(stacklist));
        return handler;
    }

    public static byte setTransferMode(ItemStack card, byte mode) {
        if (mode == 0) {
            card.remove(LaserIODataComponents.CARD_TRANSFER_MODE);
        } else {
            card.set(LaserIODataComponents.CARD_TRANSFER_MODE, (Object)mode);
        }
        return mode;
    }

    public static byte getTransferMode(ItemStack card) {
        return ((Number)card.getOrDefault(LaserIODataComponents.CARD_TRANSFER_MODE, (Object)0)).byteValue();
    }

    public static byte nextTransferMode(ItemStack card) {
        byte mode = BaseCard.getTransferMode(card);
        return BaseCard.setTransferMode(card, (byte)(mode == 3 ? 0 : mode + 1));
    }

    public static TransferMode getNamedTransferMode(ItemStack card) {
        return TransferMode.values()[BaseCard.getTransferMode(card)];
    }

    public static byte setChannel(ItemStack card, byte channel) {
        if (channel == 0) {
            card.remove(LaserIODataComponents.CARD_CHANNEL);
        } else {
            card.set(LaserIODataComponents.CARD_CHANNEL, (Object)channel);
        }
        return channel;
    }

    public static byte getChannel(ItemStack card) {
        return ((Number)card.getOrDefault(LaserIODataComponents.CARD_CHANNEL, (Object)0)).byteValue();
    }

    public static byte nextChannel(ItemStack card) {
        byte k = BaseCard.getChannel(card);
        return BaseCard.setChannel(card, (byte)(k == 15 ? 0 : k + 1));
    }

    public static byte previousChannel(ItemStack card) {
        byte k = BaseCard.getChannel(card);
        return BaseCard.setChannel(card, (byte)(k == 0 ? 15 : k - 1));
    }

    public static int setExtractSpeed(ItemStack card, int itemextractspeed) {
        if (itemextractspeed == 20) {
            card.remove(LaserIODataComponents.CARD_EXTRACT_SPEED);
        } else {
            card.set(LaserIODataComponents.CARD_EXTRACT_SPEED, (Object)itemextractspeed);
        }
        return itemextractspeed;
    }

    public static int getExtractSpeed(ItemStack card) {
        return (Integer)card.getOrDefault(LaserIODataComponents.CARD_EXTRACT_SPEED, (Object)20);
    }

    public static short setPriority(ItemStack card, short priority) {
        if (priority == 0) {
            card.remove(LaserIODataComponents.CARD_PRIORITY);
        } else {
            card.set(LaserIODataComponents.CARD_PRIORITY, (Object)priority);
        }
        return priority;
    }

    public static short getPriority(ItemStack card) {
        return ((Number)card.getOrDefault(LaserIODataComponents.CARD_PRIORITY, (Object)0)).shortValue();
    }

    public static ItemStack getFilter(ItemStack card) {
        CardItemHandler cardItemHandler = BaseCard.getInventory(card);
        return cardItemHandler.getStackInSlot(0);
    }

    public static byte setSneaky(ItemStack card, byte sneaky) {
        if (sneaky == -1) {
            card.remove(LaserIODataComponents.CARD_SNEAKY);
        } else {
            card.set(LaserIODataComponents.CARD_SNEAKY, (Object)sneaky);
        }
        return sneaky;
    }

    public static byte getSneaky(ItemStack card) {
        return ((Number)card.getOrDefault(LaserIODataComponents.CARD_SNEAKY, (Object)-1)).byteValue();
    }

    public static byte nextSneaky(ItemStack card) {
        byte k = BaseCard.getSneaky(card);
        return BaseCard.setSneaky(card, (byte)(k == 5 ? -1 : k + 1));
    }

    public static byte previousSneaky(ItemStack card) {
        byte k = BaseCard.getSneaky(card);
        return BaseCard.setSneaky(card, (byte)(k == -1 ? 5 : k - 1));
    }

    public static boolean getRegulate(ItemStack stack) {
        return (Boolean)stack.getOrDefault(LaserIODataComponents.CARD_REGULATE, (Object)false);
    }

    public static boolean setRegulate(ItemStack stack, boolean regulate) {
        if (!regulate) {
            stack.remove(LaserIODataComponents.CARD_REGULATE);
        } else {
            stack.set(LaserIODataComponents.CARD_REGULATE, (Object)regulate);
        }
        return regulate;
    }

    public static int getRoundRobin(ItemStack stack) {
        return (Integer)stack.getOrDefault(LaserIODataComponents.CARD_ROUND_ROBIN, (Object)0);
    }

    public static int setRoundRobin(ItemStack stack, int roundRobin) {
        if (roundRobin == 0) {
            stack.remove(LaserIODataComponents.CARD_ROUND_ROBIN);
        } else {
            stack.set(LaserIODataComponents.CARD_ROUND_ROBIN, (Object)roundRobin);
        }
        return roundRobin;
    }

    public static byte getRedstoneMode(ItemStack stack) {
        return ((Number)stack.getOrDefault(LaserIODataComponents.CARD_REDSTONE_MODE, (Object)0)).byteValue();
    }

    public static byte setRedstoneMode(ItemStack stack, byte redstoneMode) {
        if (redstoneMode == 0) {
            stack.remove(LaserIODataComponents.CARD_REDSTONE_MODE);
        } else {
            stack.set(LaserIODataComponents.CARD_REDSTONE_MODE, (Object)redstoneMode);
        }
        return redstoneMode;
    }

    public static byte nextRedstoneMode(ItemStack card) {
        byte mode = BaseCard.getRedstoneMode(card);
        return BaseCard.setRedstoneMode(card, (byte)(mode == 2 ? 0 : mode + 1));
    }

    public static boolean getExact(ItemStack stack) {
        return (Boolean)stack.getOrDefault(LaserIODataComponents.CARD_EXACT, (Object)false);
    }

    public static boolean setExact(ItemStack stack, boolean exact) {
        if (!exact) {
            stack.remove(LaserIODataComponents.CARD_EXACT);
        } else {
            stack.set(LaserIODataComponents.CARD_EXACT, (Object)exact);
        }
        return exact;
    }

    public static byte setRedstoneChannel(ItemStack card, byte redstonechannel) {
        if (redstonechannel == 0) {
            card.remove(LaserIODataComponents.CARD_REDSTONE_CHANNEL);
        } else {
            card.set(LaserIODataComponents.CARD_REDSTONE_CHANNEL, (Object)redstonechannel);
        }
        return redstonechannel;
    }

    public static byte getRedstoneChannel(ItemStack card) {
        return ((Number)card.getOrDefault(LaserIODataComponents.CARD_REDSTONE_CHANNEL, (Object)0)).byteValue();
    }

    public static byte nextRedstoneChannel(ItemStack card) {
        byte k = BaseCard.getRedstoneChannel(card);
        return BaseCard.setRedstoneChannel(card, (byte)(k == 15 ? 0 : k + 1));
    }

    public static byte previousRedstoneChannel(ItemStack card) {
        byte k = BaseCard.getRedstoneChannel(card);
        return BaseCard.setRedstoneChannel(card, (byte)(k == 0 ? 15 : k - 1));
    }

    public static boolean getAnd(ItemStack stack) {
        return (Boolean)stack.getOrDefault(LaserIODataComponents.CARD_AND_MODE, (Object)false);
    }

    public static boolean setAnd(ItemStack stack, boolean and) {
        if (!and) {
            stack.remove(LaserIODataComponents.CARD_AND_MODE);
        } else {
            stack.set(LaserIODataComponents.CARD_AND_MODE, (Object)and);
        }
        return and;
    }

    public static enum CardType {
        ITEM,
        FLUID,
        ENERGY,
        REDSTONE,
        CHEMICAL,
        MISSING;

    }

    public static enum TransferMode {
        INSERT,
        EXTRACT,
        STOCK,
        SENSOR;

    }
}

