/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.laserio.common.events;

import com.direwolf20.laserio.common.network.data.NodeParticlesChemicalPayload;
import com.direwolf20.laserio.common.network.data.NodeParticlesFluidPayload;
import com.direwolf20.laserio.common.network.data.NodeParticlesPayload;
import com.direwolf20.laserio.integration.mekanism.client.chemicalparticle.ParticleDataChemical;
import com.direwolf20.laserio.util.MiscTools;
import com.direwolf20.laserio.util.ParticleData;
import com.direwolf20.laserio.util.ParticleDataFluid;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import net.neoforged.neoforge.network.PacketDistributor;

public class ServerTickHandler {
    private static List<ParticleData> particleList = new ArrayList<ParticleData>();
    private static List<ParticleDataFluid> particleListFluid = new ArrayList<ParticleDataFluid>();
    private static List<ParticleDataChemical> particleListChemical = new ArrayList<ParticleDataChemical>();

    @SubscribeEvent
    public static void handleTickEndEvent(ServerTickEvent.Post event) {
        HashSet<Object> levels;
        if (!particleList.isEmpty()) {
            levels = new HashSet<Object>();
            for (ParticleData particleData : particleList) {
                levels.add(MiscTools.getLevel(event.getServer(), particleData.fromData.node()));
                levels.add(MiscTools.getLevel(event.getServer(), particleData.toData.node()));
            }
            for (Level level : levels) {
                PacketDistributor.sendToPlayersInDimension((ServerLevel)((ServerLevel)level), (CustomPacketPayload)new NodeParticlesPayload(List.copyOf(particleList)), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            particleList.clear();
        }
        if (!particleListFluid.isEmpty()) {
            levels = new HashSet();
            for (ParticleDataFluid particleDataFluid : particleListFluid) {
                levels.add(MiscTools.getLevel(event.getServer(), particleDataFluid.fromData.node()));
                levels.add(MiscTools.getLevel(event.getServer(), particleDataFluid.toData.node()));
            }
            for (Level level : levels) {
                PacketDistributor.sendToPlayersInDimension((ServerLevel)((ServerLevel)level), (CustomPacketPayload)new NodeParticlesFluidPayload(List.copyOf(particleListFluid)), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            particleListFluid.clear();
        }
        if (!particleListChemical.isEmpty()) {
            levels = new HashSet();
            for (ParticleDataChemical particleDataChemical : particleListChemical) {
                levels.add(event.getServer().getLevel(particleDataChemical.fromData.node().dimension()));
                levels.add(event.getServer().getLevel(particleDataChemical.toData.node().dimension()));
            }
            for (Level level : levels) {
                PacketDistributor.sendToPlayersInDimension((ServerLevel)((ServerLevel)level), (CustomPacketPayload)new NodeParticlesChemicalPayload(List.copyOf(particleListChemical)), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            particleListChemical.clear();
        }
    }

    public static void addToList(ParticleData particleData) {
        particleList.add(particleData);
    }

    public static void addToListFluid(ParticleDataFluid particleData) {
        particleListFluid.add(particleData);
    }

    public static void addToListFluid(ParticleDataChemical particleData) {
        particleListChemical.add(particleData);
    }
}

