/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.laserio.common.containers.customhandler;

import com.direwolf20.laserio.common.containers.customhandler.DireItemContainerContents;
import com.direwolf20.laserio.setup.LaserIODataComponents;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandlerModifiable;

public class DataComponentHandler
implements IItemHandlerModifiable {
    private final ItemStack stack;
    private final int size;

    public DataComponentHandler(ItemStack stack, int size) {
        this.stack = stack;
        this.size = size;
    }

    public int getSlots() {
        return this.size;
    }

    public ItemStack getStackInSlot(int slot) {
        this.validateSlotIndex(slot);
        if (this.getItemList().size() < slot + 1) {
            return ItemStack.EMPTY;
        }
        return (ItemStack)this.getItemList().get(slot);
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        boolean reachedLimit;
        if (stack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        if (!this.isItemValid(slot, stack)) {
            return stack;
        }
        this.validateSlotIndex(slot);
        NonNullList<ItemStack> itemStacks = this.getItemList();
        ItemStack existing = (ItemStack)itemStacks.get(slot);
        int limit = Math.min(this.getSlotLimit(slot), stack.getMaxStackSize());
        if (!existing.isEmpty()) {
            if (!ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)existing)) {
                return stack;
            }
            limit -= existing.getCount();
        }
        if (limit <= 0) {
            return stack;
        }
        boolean bl = reachedLimit = stack.getCount() > limit;
        if (!simulate) {
            if (existing.isEmpty()) {
                itemStacks.set(slot, (Object)(reachedLimit ? stack.copyWithCount(limit) : stack));
            } else {
                existing.grow(reachedLimit ? limit : stack.getCount());
            }
            this.setItemList(itemStacks);
        }
        return reachedLimit ? stack.copyWithCount(stack.getCount() - limit) : ItemStack.EMPTY;
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        NonNullList<ItemStack> itemStacks = this.getItemList();
        if (amount == 0) {
            return ItemStack.EMPTY;
        }
        this.validateSlotIndex(slot);
        ItemStack existing = (ItemStack)itemStacks.get(slot);
        if (existing.isEmpty()) {
            return ItemStack.EMPTY;
        }
        int toExtract = Math.min(amount, existing.getMaxStackSize());
        if (existing.getCount() <= toExtract) {
            if (!simulate) {
                itemStacks.set(slot, (Object)ItemStack.EMPTY);
                this.setItemList(itemStacks);
                return existing;
            }
            return existing.copy();
        }
        if (!simulate) {
            itemStacks.set(slot, (Object)existing.copyWithCount(existing.getCount() - toExtract));
            this.setItemList(itemStacks);
        }
        return existing.copyWithCount(toExtract);
    }

    private void validateSlotIndex(int slot) {
        if (slot < 0 || slot >= this.getSlots()) {
            throw new RuntimeException("Slot " + slot + " not in valid range - [0," + this.getSlots() + ")");
        }
    }

    public int getSlotLimit(int slot) {
        return 64;
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        return stack.getItem().canFitInsideContainerItems();
    }

    public void setStackInSlot(int slot, ItemStack stack) {
        this.validateSlotIndex(slot);
        if (!stack.isEmpty() && !this.isItemValid(slot, stack)) {
            throw new RuntimeException("Invalid stack " + String.valueOf(stack) + " for slot " + slot + ")");
        }
        NonNullList<ItemStack> itemStacks = this.getItemList();
        itemStacks.set(slot, (Object)stack);
        this.setItemList(itemStacks);
    }

    private NonNullList<ItemStack> getItemList() {
        DireItemContainerContents contents = (DireItemContainerContents)this.stack.getOrDefault(LaserIODataComponents.ITEMSTACK_HANDLER, (Object)DireItemContainerContents.fromItems((List<ItemStack>)NonNullList.withSize((int)this.size, (Object)ItemStack.EMPTY)));
        NonNullList list = NonNullList.withSize((int)this.size, (Object)ItemStack.EMPTY);
        contents.copyInto((NonNullList<ItemStack>)list);
        return list;
    }

    private void setItemList(NonNullList<ItemStack> itemStacks) {
        this.stack.set(LaserIODataComponents.ITEMSTACK_HANDLER, (Object)DireItemContainerContents.fromItems(itemStacks));
    }
}

