/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.laserio.common.containers;

import com.direwolf20.laserio.common.blockentities.LaserNodeBE;
import com.direwolf20.laserio.common.containers.customhandler.LaserNodeItemHandler;
import com.direwolf20.laserio.common.containers.customslot.CardHolderSlot;
import com.direwolf20.laserio.common.containers.customslot.LaserNodeSlot;
import com.direwolf20.laserio.common.items.CardHolder;
import com.direwolf20.laserio.common.items.cards.BaseCard;
import com.direwolf20.laserio.common.items.filters.BaseFilter;
import com.direwolf20.laserio.common.items.upgrades.OverclockerCard;
import com.direwolf20.laserio.common.items.upgrades.OverclockerNode;
import com.direwolf20.laserio.setup.Registration;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.SlotItemHandler;
import net.neoforged.neoforge.items.wrapper.InvWrapper;

public class LaserNodeContainer
extends AbstractContainerMenu {
    public static int SLOTS = 25;
    public static final int CARDHOLDERSLOTS = 15;
    public static final int CARDSLOTS = 9;
    public Player playerEntity;
    private IItemHandler playerInventory;
    ContainerLevelAccess containerLevelAccess;
    public ItemStack cardHolder;
    public IItemHandler cardHolderHandler;
    public UUID cardHolderUUID;
    public LaserNodeBE tile;
    public byte side;

    public LaserNodeContainer(int windowId, Inventory playerInventory, Player player, RegistryFriendlyByteBuf extraData) {
        this((LaserNodeBE)playerInventory.player.level().getBlockEntity(extraData.readBlockPos()), windowId, extraData.readByte(), playerInventory, player, new LaserNodeItemHandler(SLOTS), ContainerLevelAccess.NULL, (ItemStack)ItemStack.OPTIONAL_STREAM_CODEC.decode((Object)extraData));
    }

    public LaserNodeContainer(@Nullable LaserNodeBE tile, int windowId, byte side, Inventory playerInventory, Player player, LaserNodeItemHandler handler, ContainerLevelAccess containerLevelAccess, ItemStack cardHolder) {
        super((MenuType)Registration.LaserNode_Container.get(), windowId);
        this.playerEntity = player;
        this.tile = tile;
        this.side = side;
        this.playerInventory = new InvWrapper((Container)playerInventory);
        this.containerLevelAccess = containerLevelAccess;
        if (handler != null) {
            this.addSlotBox((IItemHandler)handler, 0, 62, 32, 3, 18, 3, 18);
            this.addSlotRange((IItemHandler)handler, 9, 152, 78, 1, 18);
        }
        this.cardHolder = cardHolder;
        this.cardHolderHandler = (IItemHandler)cardHolder.getCapability(Capabilities.ItemHandler.ITEM, null);
        if (this.cardHolderHandler == null) {
            this.cardHolderHandler = new ItemStackHandler(15);
        }
        this.addSlotBox(this.cardHolderHandler, 0, -92, 32, 5, 18, 3, 18);
        this.cardHolderUUID = CardHolder.getUUID(cardHolder);
        this.layoutPlayerInventorySlots(8, 99);
    }

    public void clicked(int slotId, int dragType, ClickType clickTypeIn, Player player) {
        if (slotId >= 0) {
            if (slotId < SLOTS && this.slots.get(slotId) instanceof CardHolderSlot) {
                ItemStack carriedItem = this.getCarried();
                ItemStack stackInSlot = ((Slot)this.slots.get(slotId)).getItem();
                if (!(stackInSlot.getMaxStackSize() != 1 || stackInSlot.getCount() <= 1 || carriedItem.isEmpty() || stackInSlot.isEmpty() || ItemStack.isSameItemSameComponents((ItemStack)carriedItem, (ItemStack)stackInSlot))) {
                    return;
                }
            } else {
                ItemStack slotItem = ((Slot)this.slots.get(slotId)).getItem();
                if (slotItem.getItem() instanceof CardHolder) {
                    return;
                }
            }
        }
        super.clicked(slotId, dragType, clickTypeIn, player);
    }

    public boolean stillValid(Player playerIn) {
        if (this.cardHolder.isEmpty() && this.cardHolderUUID != null) {
            Inventory playerInventory = this.playerEntity.getInventory();
            for (int i = 0; i < playerInventory.items.size(); ++i) {
                ItemStack itemStack = (ItemStack)playerInventory.items.get(i);
                if (!(itemStack.getItem() instanceof CardHolder) || !CardHolder.getUUID(itemStack).equals(this.cardHolderUUID)) continue;
                this.cardHolder = itemStack;
                break;
            }
        }
        return LaserNodeContainer.stillValid((ContainerLevelAccess)this.containerLevelAccess, (Player)this.playerEntity, (Block)((Block)Registration.LaserNode.get()));
    }

    protected boolean moveItemStackTo(ItemStack itemStack, int fromSlot, int toSlot, boolean p_38907_) {
        boolean flag = false;
        int i = fromSlot;
        if (p_38907_) {
            i = toSlot - 1;
        }
        while (!itemStack.isEmpty() && !(!p_38907_ ? i >= toSlot : i < fromSlot)) {
            Slot slot = (Slot)this.slots.get(i);
            ItemStack itemstack = slot.getItem();
            if (!itemstack.isEmpty() && ItemStack.isSameItemSameComponents((ItemStack)itemStack, (ItemStack)itemstack)) {
                int maxSize;
                int j = itemstack.getCount() + itemStack.getCount();
                if (j <= (maxSize = Math.min(slot.getMaxStackSize(), slot.getMaxStackSize(itemStack)))) {
                    itemStack.setCount(0);
                    itemstack.setCount(j);
                    slot.setByPlayer(itemstack);
                    slot.setChanged();
                    flag = true;
                } else if (itemstack.getCount() < maxSize) {
                    itemStack.shrink(maxSize - itemstack.getCount());
                    itemstack.setCount(maxSize);
                    slot.setByPlayer(itemstack);
                    slot.setChanged();
                    flag = true;
                }
            }
            if (p_38907_) {
                --i;
                continue;
            }
            ++i;
        }
        if (!itemStack.isEmpty()) {
            i = p_38907_ ? toSlot - 1 : fromSlot;
            while (!(!p_38907_ ? i >= toSlot : i < fromSlot)) {
                Slot slot1 = (Slot)this.slots.get(i);
                ItemStack itemstack1 = slot1.getItem();
                if (itemstack1.isEmpty() && slot1.mayPlace(itemStack) && slot1.getItem().getCount() < slot1.getMaxStackSize(itemStack)) {
                    if (itemStack.getCount() > slot1.getMaxStackSize()) {
                        slot1.set(itemStack.split(slot1.getMaxStackSize()));
                    } else {
                        slot1.set(itemStack.split(slot1.getMaxStackSize(itemStack)));
                    }
                    slot1.setChanged();
                    flag = true;
                    break;
                }
                if (p_38907_) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        return flag;
    }

    public boolean canTakeItemForPickAll(ItemStack itemStack, Slot slot) {
        return !(slot instanceof CardHolderSlot) && !(slot instanceof LaserNodeSlot);
    }

    public ItemStack quickMoveStack(Player playerIn, int index) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        ItemStack stack = slot.getItem();
        if (slot instanceof CardHolderSlot) {
            ItemStack stackToMove = stack.getMaxStackSize() == 1 ? stack.split(1) : stack;
            if (this.moveItemStackTo(stackToMove, 0, 10, false)) {
                slot.set(stack);
                return ItemStack.EMPTY;
            }
            if (this.moveItemStackTo(stackToMove, SLOTS, 36 + SLOTS, true)) {
                slot.set(stack);
                return ItemStack.EMPTY;
            }
            stack.grow(1);
            return ItemStack.EMPTY;
        }
        if (index < 9) {
            if (!this.cardHolder.isEmpty()) {
                if (this.moveItemStackTo(stack, 10, SLOTS, false)) {
                    if (!playerIn.level().isClientSide() && this.tile != null) {
                        this.tile.updateThisNode();
                    }
                    return ItemStack.EMPTY;
                }
                if (super.moveItemStackTo(stack, SLOTS, 36 + SLOTS, true)) {
                    if (!playerIn.level().isClientSide() && this.tile != null) {
                        this.tile.updateThisNode();
                    }
                    return ItemStack.EMPTY;
                }
            } else if (super.moveItemStackTo(stack, SLOTS, 36 + SLOTS, true)) {
                if (!playerIn.level().isClientSide() && this.tile != null) {
                    this.tile.updateThisNode();
                }
                return ItemStack.EMPTY;
            }
        } else {
            if (stack.getItem() instanceof OverclockerNode) {
                itemstack = stack.copy();
                if (!this.cardHolder.isEmpty()) {
                    if (index < SLOTS) {
                        if (this.moveItemStackTo(stack, 10, SLOTS, false)) {
                            return ItemStack.EMPTY;
                        }
                        if (!super.moveItemStackTo(stack, SLOTS, 36 + SLOTS, true)) {
                            return ItemStack.EMPTY;
                        }
                        slot.onQuickCraft(stack, itemstack);
                    } else {
                        if (!super.moveItemStackTo(stack, 0, SLOTS - 15, false)) {
                            return ItemStack.EMPTY;
                        }
                        if (!playerIn.level().isClientSide() && this.tile != null) {
                            this.tile.updateThisNode();
                        }
                    }
                } else if (index < SLOTS) {
                    if (!super.moveItemStackTo(stack, SLOTS, 36 + SLOTS, true)) {
                        return ItemStack.EMPTY;
                    }
                    slot.onQuickCraft(stack, itemstack);
                } else {
                    if (!super.moveItemStackTo(stack, 0, SLOTS - 15, false)) {
                        return ItemStack.EMPTY;
                    }
                    if (!playerIn.level().isClientSide() && this.tile != null) {
                        this.tile.updateThisNode();
                    }
                }
                if (stack.isEmpty()) {
                    slot.set(ItemStack.EMPTY);
                } else {
                    slot.setChanged();
                }
                if (stack.getCount() == itemstack.getCount()) {
                    return ItemStack.EMPTY;
                }
                slot.onTake(playerIn, stack);
                return itemstack;
            }
            if (stack.getItem() instanceof BaseCard || stack.getItem() instanceof BaseFilter || stack.getItem() instanceof OverclockerCard) {
                if (!this.cardHolder.isEmpty()) {
                    if (super.moveItemStackTo(stack, 0, 9, false)) {
                        return ItemStack.EMPTY;
                    }
                    if (this.moveItemStackTo(stack, 10, SLOTS, false)) {
                        return ItemStack.EMPTY;
                    }
                } else if (super.moveItemStackTo(stack, 0, 9, false)) {
                    return ItemStack.EMPTY;
                }
            } else {
                return ItemStack.EMPTY;
            }
        }
        return ItemStack.EMPTY;
    }

    private int addSlotRange(IItemHandler handler, int index, int x, int y, int amount, int dx) {
        for (int i = 0; i < amount; ++i) {
            if (handler instanceof LaserNodeItemHandler && index < 9) {
                this.addSlot((Slot)new LaserNodeSlot(handler, index, x, y));
            } else if (handler.getSlots() == 15) {
                this.addSlot((Slot)new CardHolderSlot(handler, index, x, y));
            } else {
                this.addSlot((Slot)new SlotItemHandler(handler, index, x, y));
            }
            x += dx;
            ++index;
        }
        return index;
    }

    private int addSlotBox(IItemHandler handler, int index, int x, int y, int horAmount, int dx, int verAmount, int dy) {
        for (int j = 0; j < verAmount; ++j) {
            index = this.addSlotRange(handler, index, x, y, horAmount, dx);
            y += dy;
        }
        return index;
    }

    private void layoutPlayerInventorySlots(int leftCol, int topRow) {
        this.addSlotBox(this.playerInventory, 9, leftCol, topRow, 9, 18, 3, 18);
        this.addSlotRange(this.playerInventory, 0, leftCol, topRow += 58, 9, 18);
    }
}

