/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.server;

import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import dev.latvian.mods.kubejs.KubeJS;
import dev.latvian.mods.kubejs.KubeJSPaths;
import dev.latvian.mods.kubejs.bindings.event.ServerEvents;
import dev.latvian.mods.kubejs.core.RecipeManagerKJS;
import dev.latvian.mods.kubejs.plugin.KubeJSPlugin;
import dev.latvian.mods.kubejs.plugin.KubeJSPlugins;
import dev.latvian.mods.kubejs.recipe.CompostableRecipesKubeEvent;
import dev.latvian.mods.kubejs.recipe.RecipesKubeEvent;
import dev.latvian.mods.kubejs.recipe.schema.RecipeSchemaStorage;
import dev.latvian.mods.kubejs.recipe.special.SpecialRecipeSerializerManager;
import dev.latvian.mods.kubejs.recipe.viewer.server.RecipeViewerData;
import dev.latvian.mods.kubejs.registry.BuilderBase;
import dev.latvian.mods.kubejs.registry.RegistryInfo;
import dev.latvian.mods.kubejs.registry.ServerRegistryKubeEvent;
import dev.latvian.mods.kubejs.script.ConsoleJS;
import dev.latvian.mods.kubejs.script.ScriptManager;
import dev.latvian.mods.kubejs.script.ScriptType;
import dev.latvian.mods.kubejs.script.data.GeneratedDataStage;
import dev.latvian.mods.kubejs.script.data.KubeFileResourcePack;
import dev.latvian.mods.kubejs.script.data.VirtualDataPack;
import dev.latvian.mods.kubejs.server.tag.PreTagKubeEvent;
import dev.latvian.mods.kubejs.util.RegistryAccessContainer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import net.minecraft.core.Registry;
import net.minecraft.resources.RegistryDataLoader;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.ResourceManager;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.neoforge.registries.DataPackRegistriesHooks;
import net.neoforged.neoforge.server.ServerLifecycleHooks;

public class ServerScriptManager
extends ScriptManager {
    private static ServerScriptManager staticInstance;
    public final Map<ResourceKey<?>, PreTagKubeEvent> preTagEvents = new ConcurrentHashMap();
    public final RecipeSchemaStorage recipeSchemaStorage = new RecipeSchemaStorage();
    public RecipeViewerData recipeViewerData = null;
    public final VirtualDataPack internalDataPack = new VirtualDataPack(GeneratedDataStage.INTERNAL);
    public final VirtualDataPack registriesDataPack = new VirtualDataPack(GeneratedDataStage.REGISTRIES);
    public final Map<GeneratedDataStage, VirtualDataPack> virtualPacks = GeneratedDataStage.forScripts(VirtualDataPack::new);
    public boolean firstLoad = true;

    public static List<PackResources> createPackResources(List<PackResources> original) {
        ArrayList<PackResources> packs = new ArrayList<PackResources>(original);
        ArrayList<PackResources> filePacks = new ArrayList<PackResources>();
        KubeFileResourcePack.scanAndLoad(KubeJSPaths.DATA, filePacks);
        filePacks.sort((p1, p2) -> p1.packId().compareToIgnoreCase(p2.packId()));
        filePacks.add(new KubeFileResourcePack(PackType.SERVER_DATA));
        int beforeModsIndex = KubeFileResourcePack.findBeforeModsIndex(packs);
        int afterModsIndex = KubeFileResourcePack.findAfterModsIndex(packs);
        ServerScriptManager manager = new ServerScriptManager();
        packs.add(beforeModsIndex, manager.virtualPacks.get((Object)GeneratedDataStage.BEFORE_MODS));
        packs.add(afterModsIndex, manager.internalDataPack);
        packs.add(afterModsIndex + 1, manager.registriesDataPack);
        packs.add(afterModsIndex + 2, manager.virtualPacks.get((Object)GeneratedDataStage.AFTER_MODS));
        packs.addAll(afterModsIndex + 3, filePacks);
        packs.add(manager.virtualPacks.get((Object)GeneratedDataStage.LAST));
        manager.reload();
        staticInstance = manager;
        if (!FMLLoader.isProduction()) {
            KubeJS.LOGGER.info("Loaded " + packs.size() + " data packs: " + packs.stream().map(PackResources::packId).collect(Collectors.joining(", ")));
        }
        return packs;
    }

    public static ServerScriptManager release() {
        ServerScriptManager instance = Objects.requireNonNull(staticInstance);
        staticInstance = null;
        return instance;
    }

    private ServerScriptManager() {
        super(ScriptType.SERVER);
        try {
            if (Files.notExists(KubeJSPaths.DATA, new LinkOption[0])) {
                Files.createDirectories(KubeJSPaths.DATA, new FileAttribute[0]);
            }
        }
        catch (Throwable ex) {
            throw new RuntimeException("KubeJS failed to register it's script loader!", ex);
        }
    }

    @Override
    public void loadFromDirectory() {
        ConsoleJS.SERVER.startCapturingErrors();
        super.loadFromDirectory();
        if (FMLLoader.getDist().isDedicatedServer()) {
            this.loadPackFromDirectory(KubeJSPaths.LOCAL_SERVER_SCRIPTS, "local server", true);
        }
    }

    @Override
    public void loadAdditional() {
        for (BuilderBase<?> builder : RegistryInfo.ALL_BUILDERS) {
            builder.generateDataJsons(this.internalDataPack);
        }
        KubeJSPlugins.forEachPlugin(this.internalDataPack, KubeJSPlugin::generateData);
        if (this.firstLoad) {
            this.firstLoad = false;
            if (ServerEvents.REGISTRY.hasListeners()) {
                RegistryOps<JsonElement> ops = RegistryAccessContainer.current.json();
                for (RegistryDataLoader.RegistryData reg : DataPackRegistriesHooks.getDataPackRegistries()) {
                    ResourceKey key = reg.key();
                    if (!ServerEvents.REGISTRY.hasListeners(key)) continue;
                    ServerEvents.REGISTRY.post(ScriptType.SERVER, key, new ServerRegistryKubeEvent(this.registriesDataPack, (ResourceKey<Registry<?>>)key, (DynamicOps<JsonElement>)ops, reg.elementCodec()));
                }
            }
        }
    }

    @Override
    public void reload() {
        this.internalDataPack.reset();
        for (VirtualDataPack pack : this.virtualPacks.values()) {
            pack.reset();
        }
        this.recipeViewerData = null;
        super.reload();
        PreTagKubeEvent.handle(this.preTagEvents);
        for (VirtualDataPack pack : this.virtualPacks.values()) {
            if (!ServerEvents.GENERATE_DATA.hasListeners(pack.stage)) continue;
            ServerEvents.GENERATE_DATA.post(ScriptType.SERVER, pack.stage, pack);
        }
    }

    public boolean recipes(RecipeManagerKJS recipeManager, ResourceManager resourceManager, Map<ResourceLocation, JsonElement> map) {
        if (ServerEvents.COMPOSTABLE_RECIPES.hasListeners()) {
            ServerEvents.COMPOSTABLE_RECIPES.post(ScriptType.SERVER, new CompostableRecipesKubeEvent());
        }
        boolean result = false;
        RecipesKubeEvent.TEMP_ITEM_TAG_LOOKUP.setValue((Object)this.getRegistries().cachedItemTags);
        this.recipeSchemaStorage.fireEvents(resourceManager);
        SpecialRecipeSerializerManager.INSTANCE.reset();
        ServerEvents.SPECIAL_RECIPES.post(ScriptType.SERVER, SpecialRecipeSerializerManager.INSTANCE);
        if (ServerEvents.RECIPES.hasListeners()) {
            new RecipesKubeEvent(this).post(recipeManager, map);
            result = true;
        }
        this.recipeViewerData = RecipeViewerData.collect();
        RecipesKubeEvent.TEMP_ITEM_TAG_LOOKUP.setValue(null);
        return result;
    }

    @Override
    protected void fullReload() {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null) {
            server.execute(() -> server.kjs$runCommand("reload"));
        }
    }

    public void reloadAndCapture() {
        this.reload();
        staticInstance = this;
    }
}

