/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.registry;

import dev.latvian.mods.kubejs.DevProperties;
import dev.latvian.mods.kubejs.event.EventResult;
import dev.latvian.mods.kubejs.event.KubeStartupEvent;
import dev.latvian.mods.kubejs.registry.AdditionalObjectRegistry;
import dev.latvian.mods.kubejs.registry.BuilderBase;
import dev.latvian.mods.kubejs.registry.BuilderType;
import dev.latvian.mods.kubejs.registry.CustomBuilderObject;
import dev.latvian.mods.kubejs.registry.RegistryInfo;
import dev.latvian.mods.kubejs.script.ConsoleJS;
import dev.latvian.mods.kubejs.util.ID;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;

public class RegistryKubeEvent<T>
implements KubeStartupEvent,
AdditionalObjectRegistry {
    private final RegistryInfo<T> registryInfo;
    public final List<BuilderBase<? extends T>> created;

    public RegistryKubeEvent(ResourceKey<Registry<T>> registryKey) {
        this.registryInfo = RegistryInfo.of(registryKey);
        this.created = new LinkedList<BuilderBase<? extends T>>();
    }

    public BuilderBase<? extends T> create(String id, String type) {
        BuilderType t;
        BuilderType builderType = t = this.registryInfo.types == null ? null : this.registryInfo.types.get(type);
        if (t == null) {
            throw new IllegalArgumentException("Unknown type '" + type + "' for object '" + id + "'!");
        }
        BuilderBase b = t.factory().createBuilder(ID.kjs(id));
        if (b == null) {
            throw new IllegalArgumentException("Unknown type '" + type + "' for object '" + id + "'!");
        }
        this.addBuilder(this.registryInfo, b);
        this.created.add(b);
        return b;
    }

    public BuilderBase<? extends T> create(String id) {
        BuilderType t = this.registryInfo.defaultType;
        if (t == null) {
            throw new IllegalArgumentException("Registry '" + String.valueOf(this.registryInfo.key.location()) + "' doesn't have a default type registered!");
        }
        BuilderBase b = t.factory().createBuilder(ID.kjs(id));
        if (b == null) {
            throw new IllegalArgumentException("Unknown type '" + t.type() + "' for object '" + id + "'!");
        }
        this.addBuilder(this.registryInfo, b);
        this.created.add(b);
        return b;
    }

    public CustomBuilderObject createCustom(String id, Supplier<Object> object) {
        if (object == null) {
            throw new IllegalArgumentException("Tried to register a null object with id: " + id);
        }
        ResourceLocation rl = ID.kjs(id);
        CustomBuilderObject b = new CustomBuilderObject(rl, object, this.registryInfo);
        this.addBuilder(this.registryInfo, b);
        this.created.add(b);
        return b;
    }

    @Override
    public void afterPosted(EventResult result) {
        for (BuilderBase<T> c : this.created) {
            c.createAdditionalObjects(this);
        }
    }

    public <R> void add(ResourceKey<Registry<R>> registry, BuilderBase<? extends R> builder) {
        this.addBuilder(RegistryInfo.of(registry), builder);
    }

    public <R> void add(RegistryInfo<R> registry, BuilderBase<? extends R> builder) {
        this.addBuilder(registry, builder);
    }

    private <R> void addBuilder(RegistryInfo<R> registry, BuilderBase<? extends R> builder) {
        if (builder == null) {
            throw new IllegalArgumentException("Can't add null builder in registry '" + String.valueOf(registry) + "'!");
        }
        if (DevProperties.get().logRegistryEventObjects) {
            ConsoleJS.STARTUP.info("~ " + String.valueOf(registry) + " | " + String.valueOf(builder.id));
        }
        if (registry.objects.containsKey(builder.id)) {
            throw new IllegalArgumentException("Duplicate key '" + String.valueOf(builder.id) + "' in registry '" + String.valueOf(registry) + "'!");
        }
        registry.objects.put(builder.id, builder);
        RegistryInfo.ALL_BUILDERS.add(builder);
    }
}

