/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.registry;

import com.mojang.serialization.Codec;
import dev.latvian.mods.kubejs.core.RegistryObjectKJS;
import dev.latvian.mods.kubejs.registry.BuilderBase;
import dev.latvian.mods.kubejs.registry.BuilderType;
import dev.latvian.mods.kubejs.registry.RegistryType;
import dev.latvian.mods.kubejs.util.Cast;
import dev.latvian.mods.kubejs.util.ID;
import java.lang.ref.WeakReference;
import java.lang.runtime.SwitchBootstraps;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.decoration.PaintingVariant;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.JukeboxSong;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidType;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RegistryInfo<T>
implements Iterable<BuilderBase<? extends T>> {
    private static final Object LOCK = new Object();
    private static final Map<ResourceKey<? extends Registry<?>>, RegistryInfo<?>> MAP = new IdentityHashMap();
    public static final List<BuilderBase<?>> ALL_BUILDERS = new LinkedList();
    public static final Codec<RegistryInfo<?>> CODEC = ResourceLocation.CODEC.xmap(rl -> RegistryInfo.of(ResourceKey.createRegistryKey((ResourceLocation)rl)), ri -> ri.key.location());
    public static final RegistryInfo<SoundEvent> SOUND_EVENT = RegistryInfo.of(Registries.SOUND_EVENT);
    public static final RegistryInfo<FluidType> FLUID_TYPE = RegistryInfo.of(NeoForgeRegistries.Keys.FLUID_TYPES);
    public static final RegistryInfo<Fluid> FLUID = RegistryInfo.of(Registries.FLUID);
    public static final RegistryInfo<MobEffect> MOB_EFFECT = RegistryInfo.of(Registries.MOB_EFFECT).languageKeyPrefix("effect");
    public static final RegistryInfo<Block> BLOCK = RegistryInfo.of(Registries.BLOCK);
    public static final RegistryInfo<EntityType<?>> ENTITY_TYPE = RegistryInfo.of(Registries.ENTITY_TYPE);
    public static final RegistryInfo<Item> ITEM = RegistryInfo.of(Registries.ITEM);
    public static final RegistryInfo<Potion> POTION = RegistryInfo.of(Registries.POTION);
    public static final RegistryInfo<ParticleType<?>> PARTICLE_TYPE = RegistryInfo.of(Registries.PARTICLE_TYPE);
    public static final RegistryInfo<BlockEntityType<?>> BLOCK_ENTITY_TYPE = RegistryInfo.of(Registries.BLOCK_ENTITY_TYPE);
    public static final RegistryInfo<PaintingVariant> PAINTING_VARIANT = RegistryInfo.of(Registries.PAINTING_VARIANT);
    public static final RegistryInfo<ResourceLocation> CUSTOM_STAT = RegistryInfo.of(Registries.CUSTOM_STAT);
    public static final RegistryInfo<MenuType<?>> MENU = RegistryInfo.of(Registries.MENU);
    public static final RegistryInfo<RecipeSerializer<?>> RECIPE_SERIALIZER = RegistryInfo.of(Registries.RECIPE_SERIALIZER);
    public static final RegistryInfo<Attribute> ATTRIBUTE = RegistryInfo.of(Registries.ATTRIBUTE);
    public static final RegistryInfo<VillagerProfession> VILLAGER_PROFESSION = RegistryInfo.of(Registries.VILLAGER_PROFESSION);
    public static final RegistryInfo<VillagerType> VILLAGER_TYPE = RegistryInfo.of(Registries.VILLAGER_TYPE);
    public static final RegistryInfo<ArmorMaterial> ARMOR_MATERIAL = RegistryInfo.of(Registries.ARMOR_MATERIAL);
    public static final RegistryInfo<PoiType> POINT_OF_INTEREST_TYPE = RegistryInfo.of(Registries.POINT_OF_INTEREST_TYPE);
    public static final RegistryInfo<ArgumentTypeInfo<?, ?>> COMMAND_ARGUMENT_TYPE = RegistryInfo.of(Registries.COMMAND_ARGUMENT_TYPE);
    public static final RegistryInfo<CreativeModeTab> CREATIVE_MODE_TAB = RegistryInfo.of(Registries.CREATIVE_MODE_TAB);
    public static final RegistryInfo<JukeboxSong> JUKEBOX_SONG = RegistryInfo.of(Registries.JUKEBOX_SONG);
    public final ResourceKey<Registry<T>> key;
    BuilderType<T> defaultType;
    Map<String, BuilderType<T>> types;
    public final Map<ResourceLocation, BuilderBase<? extends T>> objects;
    public final ResourceKey<T> unknownKey;
    public boolean hasDefaultTags = false;
    public boolean bypassServerOnly;
    public String languageKeyPrefix;
    private WeakReference<Registry<T>> vanillaRegistry;
    private Codec<T> codec;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> RegistryInfo<T> of(ResourceKey<Registry<T>> key) {
        Object object = LOCK;
        synchronized (object) {
            return (RegistryInfo)Cast.to(MAP.computeIfAbsent(key, RegistryInfo::new));
        }
    }

    public static RegistryInfo<?> wrap(Object from) {
        Object object = from;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{RegistryInfo.class, ResourceKey.class, Registry.class, RegistryType.class, String.class, RegistryObjectKJS.class, Holder.class}, (Object)object, n)) {
            case 0 -> {
                RegistryInfo r;
                yield r = (RegistryInfo)object;
            }
            case 1 -> {
                ResourceKey k = (ResourceKey)object;
                yield RegistryInfo.of(k);
            }
            case 2 -> {
                Registry r = (Registry)object;
                yield RegistryInfo.of(r.key());
            }
            case 3 -> {
                RegistryType t = (RegistryType)object;
                yield RegistryInfo.of(t.key());
            }
            case 4 -> {
                String ignore = (String)object;
                yield RegistryInfo.of(ResourceKey.createRegistryKey((ResourceLocation)ID.mc(from)));
            }
            case 5 -> {
                RegistryObjectKJS r = (RegistryObjectKJS)object;
                yield r.kjs$getKubeRegistry();
            }
            case 6 -> {
                Holder h = (Holder)object;
                yield RegistryInfo.of(((ResourceKey)h.unwrapKey().orElseThrow()).registryKey());
            }
            default -> throw new IllegalArgumentException("Invalid registry: " + String.valueOf(from));
        };
    }

    private RegistryInfo(ResourceKey key) {
        this.key = key;
        this.objects = new LinkedHashMap<ResourceLocation, BuilderBase<? extends T>>();
        this.unknownKey = ResourceKey.create((ResourceKey)key, (ResourceLocation)ID.UNKNOWN);
        this.bypassServerOnly = false;
        this.languageKeyPrefix = key.location().getPath().replace('/', '.');
    }

    public RegistryInfo<T> bypassServerOnly() {
        this.bypassServerOnly = true;
        return this;
    }

    public RegistryInfo<T> languageKeyPrefix(String prefix) {
        this.languageKeyPrefix = prefix;
        return this;
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (obj == this) return true;
        if (!(obj instanceof RegistryInfo)) return false;
        RegistryInfo ri = (RegistryInfo)obj;
        if (!this.key.equals(ri.key)) return false;
        return true;
    }

    public String toString() {
        return this.key.location().toString();
    }

    @Override
    @NotNull
    public Iterator<BuilderBase<? extends T>> iterator() {
        return this.objects.values().iterator();
    }

    public Registry<T> getVanillaRegistry() {
        Registry reg;
        Registry registry = reg = this.vanillaRegistry == null ? null : (Registry)this.vanillaRegistry.get();
        if (reg == null && (reg = (Registry)BuiltInRegistries.REGISTRY.get(this.key)) != null) {
            this.vanillaRegistry = new WeakReference<Registry>(reg);
        }
        return reg;
    }

    public Codec<T> valueByNameCodec() {
        if (this.codec == null) {
            this.codec = this.getVanillaRegistry().byNameCodec();
        }
        return this.codec;
    }

    public Set<Map.Entry<ResourceKey<T>, T>> entrySet() {
        return this.getVanillaRegistry().entrySet();
    }

    public ResourceLocation getId(T value) {
        return this.getVanillaRegistry().getKey(value);
    }

    public T getValue(ResourceLocation id) {
        return (T)this.getVanillaRegistry().get(id);
    }

    public Holder.Reference<T> getHolder(ResourceLocation id) {
        return (Holder.Reference)this.getVanillaRegistry().getHolder(id).orElseThrow();
    }

    public Holder.Reference<T> getHolder(ResourceKey<T> key) {
        return this.getVanillaRegistry().getHolderOrThrow(key);
    }

    public Holder<T> getHolderOf(T value) {
        return this.getVanillaRegistry().wrapAsHolder(value);
    }

    public boolean hasValue(ResourceLocation id) {
        return this.getVanillaRegistry().containsKey(id);
    }

    public ResourceKey<T> getKeyOf(T value) {
        return this.getVanillaRegistry().getResourceKey(value).orElse(this.unknownKey);
    }

    @Nullable
    public BuilderType<T> getDefaultType() {
        return this.defaultType;
    }

    public Collection<BuilderType<T>> getTypes() {
        return this.types == null ? List.of() : List.copyOf(this.types.values());
    }
}

