/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.registry;

import dev.latvian.mods.kubejs.CommonProperties;
import dev.latvian.mods.kubejs.DevProperties;
import dev.latvian.mods.kubejs.KubeJS;
import dev.latvian.mods.kubejs.registry.BuilderBase;
import dev.latvian.mods.kubejs.registry.RegistryInfo;
import dev.latvian.mods.kubejs.script.ConsoleJS;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.registries.RegisterEvent;

@EventBusSubscriber(modid="kubejs", bus=EventBusSubscriber.Bus.MOD)
public class RegistryEventHandler {
    @SubscribeEvent(priority=EventPriority.LOW)
    public static void registerAll(RegisterEvent event) {
        RegistryEventHandler.handleRegistryEvent(RegistryInfo.of(event.getRegistryKey()), event);
    }

    private static <T> void handleRegistryEvent(RegistryInfo<T> registryInfo, RegisterEvent event) {
        if (!registryInfo.bypassServerOnly && CommonProperties.get().serverOnly) {
            if (DevProperties.get().logRegistryEventObjects) {
                KubeJS.LOGGER.warn("Skipping " + String.valueOf(registryInfo) + " registry - server only");
            }
            return;
        }
        if (registryInfo.objects.isEmpty()) {
            if (DevProperties.get().logRegistryEventObjects) {
                KubeJS.LOGGER.info("Skipping " + String.valueOf(registryInfo) + " registry - no objects to build");
            }
            return;
        }
        if (DevProperties.get().logRegistryEventObjects) {
            KubeJS.LOGGER.info("Building " + registryInfo.objects.size() + " objects of " + String.valueOf(registryInfo) + " registry");
        }
        int added = 0;
        for (BuilderBase<T> builder : registryInfo) {
            if (builder.dummyBuilder) continue;
            event.register(registryInfo.key, builder.id, builder::createTransformedObject);
            if (DevProperties.get().logRegistryEventObjects) {
                ConsoleJS.STARTUP.info("+ " + String.valueOf(registryInfo) + " | " + String.valueOf(builder.id));
            }
            ++added;
        }
        if (!registryInfo.objects.isEmpty() && DevProperties.get().logRegistryEventObjects) {
            KubeJS.LOGGER.info("Registered " + added + "/" + registryInfo.objects.size() + " objects of " + String.valueOf(registryInfo));
        }
    }
}

