/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.registry;

import dev.latvian.mods.kubejs.registry.BuilderBase;
import dev.latvian.mods.kubejs.registry.BuilderFactory;
import dev.latvian.mods.kubejs.registry.BuilderType;
import dev.latvian.mods.kubejs.registry.BuilderTypeRegistry;
import dev.latvian.mods.kubejs.registry.RegistryInfo;
import dev.latvian.mods.kubejs.script.ConsoleJS;
import java.util.LinkedHashMap;
import java.util.function.Consumer;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;

public class BuilderTypeRegistryHandler
implements BuilderTypeRegistry {
    @Override
    public <T> void of(ResourceKey<Registry<T>> registry, Consumer<BuilderTypeRegistry.Callback<T>> callback) {
        callback.accept(new RegConsumer<T>(RegistryInfo.of(registry)));
    }

    private record RegConsumer<T>(RegistryInfo<T> registryInfo) implements BuilderTypeRegistry.Callback<T>
    {
        @Override
        public void addDefault(Class<? extends BuilderBase<? extends T>> builderType, BuilderFactory factory) {
            if (this.registryInfo.defaultType != null) {
                ConsoleJS.STARTUP.warn("Previous default type '" + this.registryInfo.defaultType.builderClass().getName() + "' for registry '" + String.valueOf(this.registryInfo) + "' replaced with '" + builderType.getName() + "'!");
            }
            this.registryInfo.defaultType = new BuilderType("default", builderType, factory);
        }

        @Override
        public void add(String type, Class<? extends BuilderBase<? extends T>> builderType, BuilderFactory factory) {
            BuilderType prev;
            if (this.registryInfo.types == null) {
                this.registryInfo.types = new LinkedHashMap();
            }
            if ((prev = this.registryInfo.types.get(type)) != null) {
                ConsoleJS.STARTUP.warn("Previous '" + type + "' type '" + prev.builderClass().getName() + "' for registry '" + String.valueOf(this.registryInfo) + "' replaced with '" + builderType.getName() + "'!");
            }
            this.registryInfo.types.put(type, new BuilderType(type, builderType, factory));
        }
    }
}

