/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.recipe.schema;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.StringReader;
import dev.latvian.mods.kubejs.bindings.event.ServerEvents;
import dev.latvian.mods.kubejs.plugin.KubeJSPlugin;
import dev.latvian.mods.kubejs.plugin.KubeJSPlugins;
import dev.latvian.mods.kubejs.recipe.component.RecipeComponent;
import dev.latvian.mods.kubejs.recipe.schema.JsonRecipeSchemaLoader;
import dev.latvian.mods.kubejs.recipe.schema.KubeRecipeFactory;
import dev.latvian.mods.kubejs.recipe.schema.RecipeComponentFactory;
import dev.latvian.mods.kubejs.recipe.schema.RecipeComponentFactoryRegistry;
import dev.latvian.mods.kubejs.recipe.schema.RecipeFactoryRegistry;
import dev.latvian.mods.kubejs.recipe.schema.RecipeMappingRegistry;
import dev.latvian.mods.kubejs.recipe.schema.RecipeNamespace;
import dev.latvian.mods.kubejs.recipe.schema.RecipeSchema;
import dev.latvian.mods.kubejs.recipe.schema.RecipeSchemaRegistry;
import dev.latvian.mods.kubejs.recipe.schema.RecipeSchemaType;
import dev.latvian.mods.kubejs.recipe.schema.UnknownRecipeSchemaType;
import dev.latvian.mods.kubejs.registry.RegistryInfo;
import dev.latvian.mods.kubejs.script.ScriptType;
import dev.latvian.mods.kubejs.util.JsonUtils;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.item.crafting.RecipeSerializer;

public class RecipeSchemaStorage {
    public final Map<ResourceLocation, KubeRecipeFactory> recipeTypes = new HashMap<ResourceLocation, KubeRecipeFactory>();
    public final Map<String, RecipeNamespace> namespaces = new HashMap<String, RecipeNamespace>();
    public final Map<String, ResourceLocation> mappings = new HashMap<String, ResourceLocation>();
    public final Map<String, RecipeComponent<?>> simpleComponents = new HashMap();
    public final Map<String, RecipeComponentFactory> dynamicComponents = new HashMap<String, RecipeComponentFactory>();
    private final Map<String, RecipeComponent<?>> componentCache = new HashMap();
    public final Map<String, RecipeSchemaType> schemaTypes = new HashMap<String, RecipeSchemaType>();
    public RecipeSchema shapedSchema;
    public RecipeSchema shapelessSchema;
    public RecipeSchema specialSchema;

    public RecipeNamespace namespace(String namespace) {
        return this.namespaces.computeIfAbsent(namespace, n -> new RecipeNamespace(this, (String)n));
    }

    public void fireEvents(ResourceManager resourceManager) {
        this.recipeTypes.clear();
        this.namespaces.clear();
        this.mappings.clear();
        this.simpleComponents.clear();
        this.dynamicComponents.clear();
        this.componentCache.clear();
        this.schemaTypes.clear();
        this.shapedSchema = null;
        this.shapelessSchema = null;
        this.specialSchema = null;
        RecipeFactoryRegistry typeEvent = new RecipeFactoryRegistry(this);
        KubeJSPlugins.forEachPlugin(typeEvent, KubeJSPlugin::registerRecipeFactories);
        for (Map.Entry entry : resourceManager.listResources("kubejs", path -> path.getPath().endsWith("/recipe_mappings.json")).entrySet()) {
            try {
                BufferedReader bufferedReader = ((Resource)entry.getValue()).openAsReader();
                try {
                    JsonObject json = (JsonObject)JsonUtils.GSON.fromJson((Reader)bufferedReader, JsonObject.class);
                    for (Map.Entry entry1 : json.entrySet()) {
                        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)((ResourceLocation)entry.getKey()).getNamespace(), (String)((String)entry1.getKey()));
                        Object object = entry1.getValue();
                        if (object instanceof JsonArray) {
                            JsonArray arr = (JsonArray)object;
                            for (JsonElement n : arr) {
                                this.mappings.put(n.getAsString(), id);
                            }
                            continue;
                        }
                        this.mappings.put(((JsonElement)entry1.getValue()).getAsString(), id);
                    }
                }
                finally {
                    if (bufferedReader == null) continue;
                    bufferedReader.close();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        RecipeMappingRegistry mappingRegistry = new RecipeMappingRegistry(this);
        KubeJSPlugins.forEachPlugin(mappingRegistry, KubeJSPlugin::registerRecipeMappings);
        ServerEvents.RECIPE_MAPPING_REGISTRY.post(ScriptType.SERVER, mappingRegistry);
        KubeJSPlugins.forEachPlugin(new RecipeComponentFactoryRegistry(this), KubeJSPlugin::registerRecipeComponents);
        for (Map.Entry entry : resourceManager.listResources("kubejs", path -> path.getPath().endsWith("/recipe_components.json")).entrySet()) {
            try {
                BufferedReader reader = ((Resource)entry.getValue()).openAsReader();
                try {
                    JsonObject json = (JsonObject)JsonUtils.GSON.fromJson((Reader)reader, JsonObject.class);
                    for (Map.Entry entry1 : json.entrySet()) {
                        this.simpleComponents.put((String)entry1.getKey(), this.getComponent(((JsonElement)entry1.getValue()).getAsString()));
                    }
                }
                finally {
                    if (reader == null) continue;
                    reader.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        for (Map.Entry<ResourceKey<RecipeSerializer<?>>, RecipeSerializer<?>> entry : RegistryInfo.RECIPE_SERIALIZER.entrySet()) {
            RecipeNamespace ns = this.namespace(entry.getKey().location().getNamespace());
            ns.put(entry.getKey().location().getPath(), new UnknownRecipeSchemaType(ns, entry.getKey().location(), entry.getValue()));
        }
        RecipeSchemaRegistry recipeSchemaRegistry = new RecipeSchemaRegistry(this);
        JsonRecipeSchemaLoader.load(this, recipeSchemaRegistry, resourceManager);
        this.shapedSchema = Objects.requireNonNull(((RecipeSchemaType)this.namespace((String)"minecraft").get((Object)"shaped")).schema);
        this.shapelessSchema = Objects.requireNonNull(((RecipeSchemaType)this.namespace((String)"minecraft").get((Object)"shapeless")).schema);
        this.specialSchema = Objects.requireNonNull(((RecipeSchemaType)this.namespace((String)"minecraft").get((Object)"special")).schema);
        KubeJSPlugins.forEachPlugin(recipeSchemaRegistry, KubeJSPlugin::registerRecipeSchemas);
        ServerEvents.RECIPE_SCHEMA_REGISTRY.post(ScriptType.SERVER, recipeSchemaRegistry);
    }

    public RecipeComponent<?> getComponent(String string) {
        RecipeComponent<?> c = this.componentCache.get(string);
        if (c == null) {
            try {
                c = this.readComponent(new StringReader(string));
                this.componentCache.put(string, c);
            }
            catch (Exception ex) {
                throw new IllegalArgumentException(ex);
            }
        }
        return c;
    }

    public RecipeComponent<?> readComponent(StringReader reader) throws Exception {
        RecipeComponentFactory d;
        RecipeComponent<Object> component;
        reader.skipWhitespace();
        Object key = reader.readUnquotedString();
        if (reader.canRead() && reader.peek() == ':') {
            reader.skip();
            key = (String)key + ":" + reader.readUnquotedString();
        }
        if ((component = this.simpleComponents.get(key)) == null && (d = this.dynamicComponents.get(key)) != null) {
            component = d.readComponent(this, reader);
        }
        if (component == null) {
            throw new UnsupportedOperationException("Recipe Component '" + (String)key + "' not found");
        }
        reader.skipWhitespace();
        while (reader.canRead() && reader.peek() == '[') {
            boolean self;
            reader.skip();
            reader.skipWhitespace();
            boolean bl = self = reader.canRead() && reader.peek() == '?';
            if (self) {
                reader.skip();
                reader.skipWhitespace();
            }
            reader.expect(']');
            component = self ? component.asListOrSelf() : component.asList();
        }
        return component;
    }
}

