/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.recipe.schema;

import dev.latvian.mods.kubejs.recipe.KubeRecipe;
import dev.latvian.mods.kubejs.recipe.RecipeKey;
import dev.latvian.mods.kubejs.util.Cast;
import dev.latvian.mods.rhino.BaseFunction;
import dev.latvian.mods.rhino.Context;
import dev.latvian.mods.rhino.Scriptable;
import dev.latvian.mods.rhino.type.TypeInfo;
import java.util.List;
import java.util.Map;

public interface RecipeSchemaFunction {
    default public TypeInfo[] getArgTypes() {
        return TypeInfo.EMPTY_ARRAY;
    }

    public void execute(Context var1, KubeRecipe var2, Object[] var3);

    public record SetManyFunction(Map<RecipeKey<?>, Object> map) implements RecipeSchemaFunction
    {
        @Override
        public void execute(Context cx, KubeRecipe recipe, Object[] args) {
            for (Map.Entry<RecipeKey<?>, Object> entry : this.map.entrySet()) {
                recipe.setValue(entry.getKey(), Cast.to(entry.getValue()));
            }
        }
    }

    public record SetFunction<T>(RecipeKey<T> key, T to) implements RecipeSchemaFunction
    {
        @Override
        public void execute(Context cx, KubeRecipe recipe, Object[] args) {
            recipe.setValue(this.key, this.to);
        }
    }

    public record Bundle(List<RecipeSchemaFunction> functions) implements RecipeSchemaFunction
    {
        @Override
        public void execute(Context cx, KubeRecipe recipe, Object[] args) {
            for (RecipeSchemaFunction function : this.functions) {
                function.execute(cx, recipe, args);
            }
        }
    }

    public static class JSFunction
    extends BaseFunction {
        public final KubeRecipe recipe;
        public final RecipeSchemaFunction func;
        public final TypeInfo[] argTypes;
        public boolean convertArgs;

        public JSFunction(KubeRecipe recipe, RecipeSchemaFunction func) {
            this.recipe = recipe;
            this.func = func;
            this.argTypes = func.getArgTypes();
            this.convertArgs = false;
            for (TypeInfo type : this.argTypes) {
                if (type == TypeInfo.NONE) continue;
                this.convertArgs = true;
                break;
            }
        }

        public KubeRecipe call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
            Object[] args1 = args;
            if (this.convertArgs) {
                args1 = new Object[args.length];
                for (int i = 0; i < args.length; ++i) {
                    args1[i] = cx.jsToJava(args[i], this.argTypes[i]);
                }
            }
            this.func.execute(cx, this.recipe, args1);
            return this.recipe;
        }
    }
}

