/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.recipe.schema;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.latvian.mods.kubejs.DevProperties;
import dev.latvian.mods.kubejs.KubeJS;
import dev.latvian.mods.kubejs.recipe.KubeRecipe;
import dev.latvian.mods.kubejs.recipe.RecipeKey;
import dev.latvian.mods.kubejs.recipe.RecipeTypeFunction;
import dev.latvian.mods.kubejs.recipe.component.UniqueIdBuilder;
import dev.latvian.mods.kubejs.recipe.schema.KubeRecipeFactory;
import dev.latvian.mods.kubejs.recipe.schema.RecipeConstructor;
import dev.latvian.mods.kubejs.recipe.schema.RecipeSchemaFunction;
import dev.latvian.mods.kubejs.util.Cast;
import dev.latvian.mods.kubejs.util.JsonUtils;
import dev.latvian.mods.rhino.util.RemapForJS;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.SequencedCollection;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class RecipeSchema {
    public static final Function<KubeRecipe, String> DEFAULT_UNIQUE_ID_FUNCTION = r -> null;
    public KubeRecipeFactory recipeFactory = KubeRecipeFactory.DEFAULT;
    public final RecipeKey<?>[] keys;
    public final Map<String, RecipeSchemaFunction> functions;
    private int inputCount;
    private int outputCount;
    private int minRequiredArguments;
    private Int2ObjectMap<RecipeConstructor> constructors;
    public Function<KubeRecipe, String> uniqueIdFunction;
    boolean hidden;

    public RecipeSchema(RecipeKey<?> ... keys) {
        this.keys = keys;
        this.functions = new LinkedHashMap<String, RecipeSchemaFunction>(0);
        this.minRequiredArguments = 0;
        this.inputCount = 0;
        this.outputCount = 0;
        HashSet<String> set = new HashSet<String>();
        for (int i = 0; i < keys.length; ++i) {
            if (keys[i].optional()) {
                if (this.minRequiredArguments == 0) {
                    this.minRequiredArguments = i;
                }
            } else if (this.minRequiredArguments > 0) {
                throw new IllegalArgumentException("Required key '" + keys[i].name + "' must be ahead of optional keys!");
            }
            if (!set.add(keys[i].name)) {
                throw new IllegalArgumentException("Duplicate key '" + keys[i].name + "' found!");
            }
            if (keys[i].role.isInput()) {
                ++this.inputCount;
            } else if (keys[i].role.isOutput()) {
                ++this.outputCount;
            }
            if (!keys[i].alwaysWrite || !keys[i].optional() || !keys[i].optional.isDefault()) continue;
            throw new IllegalArgumentException("Key '" + String.valueOf(keys[i]) + "' can't have alwaysWrite() enabled with defaultOptional()!");
        }
        if (this.minRequiredArguments == 0) {
            this.minRequiredArguments = keys.length;
        }
        this.uniqueIdFunction = DEFAULT_UNIQUE_ID_FUNCTION;
        this.hidden = false;
    }

    public RecipeSchema factory(KubeRecipeFactory factory) {
        this.recipeFactory = factory;
        return this;
    }

    public RecipeSchema constructor(RecipeConstructor constructor) {
        if (this.constructors == null) {
            this.constructors = new Int2ObjectArrayMap(this.keys.length - this.minRequiredArguments + 1);
        }
        if (this.constructors.put(constructor.keys.length, (Object)constructor) != null) {
            throw new IllegalStateException("Constructor with " + constructor.keys.length + " arguments already exists!");
        }
        return this;
    }

    @RemapForJS(value="addConstructor")
    public RecipeSchema constructor(RecipeKey<?> ... keys) {
        return this.constructor(new RecipeConstructor(keys));
    }

    public RecipeSchema uniqueId(Function<KubeRecipe, String> uniqueIdFunction) {
        this.uniqueIdFunction = uniqueIdFunction;
        return this;
    }

    public RecipeSchema uniqueId(RecipeKey<?> key) {
        return this.uniqueId((KubeRecipe r) -> {
            Object value = r.getValue(key);
            if (value != null) {
                UniqueIdBuilder builder = new UniqueIdBuilder(new StringBuilder());
                key.component.buildUniqueId(builder, Cast.to(value));
                return builder.build();
            }
            return null;
        });
    }

    public RecipeSchema uniqueIds(SequencedCollection<RecipeKey<?>> keys) {
        if (keys.isEmpty()) {
            return this.uniqueId(DEFAULT_UNIQUE_ID_FUNCTION);
        }
        if (keys.size() == 1) {
            return this.uniqueId(keys.getFirst());
        }
        return this.uniqueId((KubeRecipe r) -> {
            StringBuilder sb = new StringBuilder();
            UniqueIdBuilder builder = new UniqueIdBuilder(new StringBuilder());
            boolean first = true;
            for (RecipeKey key : keys) {
                Object value = r.getValue(key);
                if (value == null) continue;
                key.component.buildUniqueId(builder, Cast.to(value));
                String result = builder.build();
                if (result == null) continue;
                if (first) {
                    first = false;
                } else {
                    sb.append('/');
                }
                sb.append(result);
            }
            return sb.isEmpty() ? null : sb.toString();
        });
    }

    public Int2ObjectMap<RecipeConstructor> constructors() {
        if (this.constructors == null) {
            RecipeKey[] keys1 = (RecipeKey[])Arrays.stream(this.keys).filter(RecipeKey::includeInAutoConstructors).toArray(RecipeKey[]::new);
            this.constructors = keys1.length == 0 ? new Int2ObjectArrayMap() : new Int2ObjectArrayMap(keys1.length - this.minRequiredArguments + 1);
            boolean dev = DevProperties.get().logRecipeDebug;
            if (dev) {
                KubeJS.LOGGER.info("Generating constructors for " + String.valueOf(new RecipeConstructor(keys1)));
            }
            for (int a = this.minRequiredArguments; a <= keys1.length; ++a) {
                RecipeKey[] k = new RecipeKey[a];
                System.arraycopy(keys1, 0, k, 0, a);
                RecipeConstructor c = new RecipeConstructor(k);
                this.constructors.put(a, (Object)c);
                if (!dev) continue;
                KubeJS.LOGGER.info("> " + a + ": " + String.valueOf(c));
            }
        }
        return this.constructors;
    }

    public int minRequiredArguments() {
        return this.minRequiredArguments;
    }

    public int inputCount() {
        return this.inputCount;
    }

    public int outputCount() {
        return this.outputCount;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public KubeRecipe deserialize(RecipeTypeFunction type, @Nullable ResourceLocation id, JsonObject json) {
        KubeRecipe r = this.recipeFactory.create();
        r.type = type;
        r.id = id;
        r.json = json;
        r.newRecipe = id == null;
        r.initValues(id == null);
        if (id != null && DevProperties.get().logRecipeDebug) {
            r.originalJson = (JsonObject)JsonUtils.copy((JsonElement)json);
        }
        r.deserialize(false);
        return r;
    }

    public RecipeSchema function(String name, RecipeSchemaFunction function) {
        this.functions.put(name, function);
        return this;
    }

    public <T> RecipeSchema setOpFunction(String name, RecipeKey<T> key, T value) {
        return this.function(name, new RecipeSchemaFunction.SetFunction<T>(key, value));
    }

    public <T> RecipeKey<T> getKey(String id) {
        for (RecipeKey<?> key : this.keys) {
            if (!key.name.equals(id)) continue;
            return key;
        }
        throw new NullPointerException("Key '" + id + "' not found");
    }
}

