/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.recipe.schema;

import com.google.gson.JsonObject;
import dev.latvian.mods.kubejs.recipe.KubeRecipe;
import dev.latvian.mods.kubejs.recipe.RecipeKey;
import dev.latvian.mods.kubejs.recipe.RecipeTypeFunction;
import dev.latvian.mods.kubejs.recipe.component.ComponentValueMap;
import dev.latvian.mods.kubejs.recipe.schema.RecipeOptional;
import dev.latvian.mods.kubejs.recipe.schema.RecipeSchemaType;
import dev.latvian.mods.kubejs.util.Cast;
import dev.latvian.mods.rhino.Context;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.stream.Collectors;

public class RecipeConstructor {
    public final RecipeKey<?>[] keys;
    public Map<RecipeKey<?>, RecipeOptional<?>> overrides;

    public RecipeConstructor(RecipeKey<?> ... keys) {
        this.keys = keys;
        this.overrides = Map.of();
    }

    public <T> RecipeConstructor override(RecipeKey<T> key, RecipeOptional<T> value) {
        if (this.overrides.isEmpty()) {
            this.overrides = new IdentityHashMap(1);
        }
        this.overrides.put(key, value);
        return this;
    }

    public <T> RecipeConstructor overrideValue(RecipeKey<T> key, T value) {
        return this.override(key, new RecipeOptional.Constant<T>(value));
    }

    public RecipeConstructor overrides(Map<RecipeKey<?>, RecipeOptional<?>> map) {
        this.overrides = map;
        return this;
    }

    public String toString() {
        return Arrays.stream(this.keys).map(RecipeKey::toString).collect(Collectors.joining(", ", "(", ")"));
    }

    public KubeRecipe create(Context cx, RecipeTypeFunction type, RecipeSchemaType schemaType, ComponentValueMap from) {
        KubeRecipe r = schemaType.schema.recipeFactory.create();
        r.type = type;
        r.json = new JsonObject();
        r.json.addProperty("type", "unknown");
        r.newRecipe = true;
        r.initValues(true);
        this.setValues(cx, r, schemaType, from);
        return r;
    }

    public void setValues(Context cx, KubeRecipe recipe, RecipeSchemaType schemaType, ComponentValueMap from) {
        for (RecipeKey<?> key : this.keys) {
            recipe.setValue(key, Cast.to(from.getValue(cx, recipe, key)));
        }
        for (Map.Entry entry : this.overrides.entrySet()) {
            recipe.setValue((RecipeKey)entry.getKey(), Cast.to(((RecipeOptional)entry.getValue()).getDefaultValue(schemaType)));
        }
    }
}

