/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.recipe.schema;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.latvian.mods.kubejs.recipe.RecipeKey;
import dev.latvian.mods.kubejs.recipe.component.ComponentRole;
import dev.latvian.mods.kubejs.recipe.component.RecipeComponent;
import dev.latvian.mods.kubejs.recipe.schema.KubeRecipeFactory;
import dev.latvian.mods.kubejs.recipe.schema.RecipeConstructor;
import dev.latvian.mods.kubejs.recipe.schema.RecipeOptional;
import dev.latvian.mods.kubejs.recipe.schema.RecipeSchema;
import dev.latvian.mods.kubejs.recipe.schema.RecipeSchemaFunction;
import dev.latvian.mods.kubejs.recipe.schema.RecipeSchemaRegistry;
import dev.latvian.mods.kubejs.recipe.schema.RecipeSchemaStorage;
import dev.latvian.mods.kubejs.script.ConsoleJS;
import dev.latvian.mods.kubejs.util.JsonUtils;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;

public class JsonRecipeSchemaLoader {
    public static void load(RecipeSchemaStorage storage, RecipeSchemaRegistry event, ResourceManager resourceManager) {
        HashMap<ResourceLocation, RecipeSchemaBuilder> map = new HashMap<ResourceLocation, RecipeSchemaBuilder>();
        for (Map.Entry entry : resourceManager.listResources("kubejs/recipe_schemas", path -> path.getPath().endsWith(".json")).entrySet()) {
            try {
                BufferedReader reader = ((Resource)entry.getValue()).openAsReader();
                try {
                    JsonObject json = (JsonObject)JsonUtils.GSON.fromJson((Reader)reader, JsonObject.class);
                    RecipeSchemaBuilder holder = new RecipeSchemaBuilder(ResourceLocation.fromNamespaceAndPath((String)((ResourceLocation)entry.getKey()).getNamespace(), (String)((ResourceLocation)entry.getKey()).getPath().substring("kubejs/recipe_schemas/".length(), ((ResourceLocation)entry.getKey()).getPath().length() - ".json".length())), json);
                    map.put(holder.id, holder);
                    if (!holder.json.has("mappings")) continue;
                    for (JsonElement m : holder.json.getAsJsonArray("mappings")) {
                        storage.mappings.put(m.getAsString(), holder.id);
                    }
                }
                finally {
                    if (reader == null) continue;
                    reader.close();
                }
            }
            catch (Exception ex) {
                ConsoleJS.SERVER.error("Error reading recipe schema json " + String.valueOf(entry.getKey()), ex);
            }
        }
        for (RecipeSchemaBuilder holder : map.values()) {
            if (holder.json.has("hidden")) {
                holder.hidden = holder.json.get("hidden").getAsBoolean();
            }
            RecipeSchemaBuilder recipeSchemaBuilder = holder.parent = holder.json.has("parent") ? (RecipeSchemaBuilder)map.get(ResourceLocation.parse((String)holder.json.get("parent").getAsString())) : null;
            if (holder.json.has("factory")) {
                ResourceLocation fname = ResourceLocation.parse((String)holder.json.get("factory").getAsString());
                holder.recipeFactory = storage.recipeTypes.get(fname);
                if (holder.recipeFactory == null) {
                    throw new NullPointerException("Recipe factory '" + String.valueOf(fname) + "' not found for recipe schema '" + String.valueOf(holder.id) + "'");
                }
            }
            if (holder.json.has("keys")) {
                holder.keys = new ArrayList();
                for (Object entry : holder.json.getAsJsonArray("keys")) {
                    try {
                        JsonArray arr;
                        JsonObject keyJson = entry.getAsJsonObject();
                        String name = keyJson.get("name").getAsString();
                        ComponentRole role = switch (keyJson.has("role") ? keyJson.get("role").getAsString() : "") {
                            case "input" -> ComponentRole.INPUT;
                            case "output" -> ComponentRole.OUTPUT;
                            default -> ComponentRole.OTHER;
                        };
                        RecipeComponent<?> type = storage.getComponent(keyJson.get("type").getAsString());
                        RecipeKey<?> key = type.key(name, role);
                        if (keyJson.has("optional")) {
                            JsonElement optionalJson = keyJson.get("optional");
                            if (optionalJson == null || optionalJson.isJsonNull()) {
                                key.defaultOptional();
                            } else {
                                try {
                                    key.optional = new RecipeOptional.Constant<Object>(((Pair)key.codec.decode((DynamicOps)JsonOps.INSTANCE, (Object)optionalJson).getOrThrow()).getFirst());
                                }
                                catch (Exception ex) {
                                    throw new IllegalArgumentException("Failed to create optional value for key '" + String.valueOf(key) + "' of '" + String.valueOf(holder.id) + "' from " + String.valueOf(optionalJson), ex);
                                }
                            }
                        }
                        if (keyJson.has("alternative_names")) {
                            arr = keyJson.getAsJsonArray("alternative_names");
                            for (JsonElement e : arr) {
                                key.names.add(e.getAsString());
                            }
                        }
                        if (keyJson.has("excluded")) {
                            key.excluded = keyJson.get("excluded").getAsBoolean();
                        }
                        if (keyJson.has("function_names")) {
                            arr = keyJson.getAsJsonArray("function_names");
                            key.functionNames = new ArrayList<String>(arr.size());
                            for (JsonElement e : arr) {
                                key.functionNames.add(e.getAsString());
                            }
                        }
                        if (keyJson.has("allow_empty")) {
                            key.allowEmpty = keyJson.get("allow_empty").getAsBoolean();
                        }
                        if (keyJson.has("always_write")) {
                            key.alwaysWrite = keyJson.get("always_write").getAsBoolean();
                        }
                        holder.keys.add(key);
                    }
                    catch (Exception ex) {
                        ConsoleJS.SERVER.error("Error parsing recipe schema '" + String.valueOf(holder.id) + "' key " + String.valueOf(entry), ex);
                    }
                }
            }
            if (holder.json.has("constructors")) {
                for (Object entry : holder.json.getAsJsonArray("constructors")) {
                    JsonObject c = entry.getAsJsonObject();
                    ConstructorBuilder constructor = new ConstructorBuilder(new ArrayList<String>(3), new HashMap<String, JsonElement>(0));
                    for (Object e : c.getAsJsonArray("keys")) {
                        constructor.keys.add(e.getAsString());
                    }
                    if (c.has("overrides")) {
                        for (Object e : c.getAsJsonObject("overrides").entrySet()) {
                            constructor.overrides.put((String)e.getKey(), (JsonElement)e.getValue());
                        }
                    }
                    if (holder.constructors == null) {
                        holder.constructors = new ArrayList<ConstructorBuilder>();
                    }
                    holder.constructors.add(constructor);
                }
            }
            if (holder.json.has("unique")) {
                Object entry;
                JsonArray arr = holder.json.getAsJsonArray("unique");
                holder.unique = new ArrayList<String>(arr.size());
                entry = arr.iterator();
                while (entry.hasNext()) {
                    JsonElement e = (JsonElement)entry.next();
                    holder.unique.add(e.getAsString());
                }
            }
            if (!holder.json.has("functions")) continue;
            holder.functions = new HashMap<String, FunctionBuilder>();
            for (Object entry : holder.json.getAsJsonObject("functions").entrySet()) {
                holder.functions.put((String)entry.getKey(), new FunctionBuilder((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsJsonObject()));
            }
        }
        for (RecipeSchemaBuilder holder : map.values()) {
            RecipeSchema schema = holder.getSchema();
            event.namespace(holder.id.getNamespace()).register(holder.id.getPath(), schema);
        }
    }

    private static final class RecipeSchemaBuilder {
        private final ResourceLocation id;
        private final JsonObject json;
        private RecipeSchemaBuilder parent;
        private List<RecipeKey<?>> keys;
        private List<ConstructorBuilder> constructors;
        private Map<String, FunctionBuilder> functions;
        private KubeRecipeFactory recipeFactory;
        private List<String> unique;
        private boolean hidden;
        private RecipeSchema schema;

        private RecipeSchemaBuilder(ResourceLocation id, JsonObject json) {
            this.id = id;
            this.json = json;
        }

        private List<RecipeKey<?>> getKeys() {
            if (this.keys != null) {
                return this.keys;
            }
            if (this.parent != null) {
                return this.parent.getKeys();
            }
            return List.of();
        }

        private List<ConstructorBuilder> getConstructors() {
            if (this.constructors != null) {
                return this.constructors;
            }
            if (this.parent != null) {
                return this.parent.getConstructors();
            }
            return List.of();
        }

        private void gatherFunctions(Map<String, FunctionBuilder> list) {
            if (this.parent != null) {
                this.parent.gatherFunctions(list);
            }
            if (this.functions != null) {
                list.putAll(this.functions);
            }
        }

        private KubeRecipeFactory getRecipeFactory() {
            if (this.recipeFactory != null) {
                return this.recipeFactory;
            }
            if (this.parent != null) {
                return this.parent.getRecipeFactory();
            }
            return null;
        }

        private List<String> getUnique() {
            if (this.unique != null) {
                return this.unique;
            }
            if (this.parent != null) {
                return this.parent.getUnique();
            }
            return List.of();
        }

        private boolean isHidden() {
            if (this.hidden) {
                return true;
            }
            if (this.parent != null) {
                return this.parent.isHidden();
            }
            return false;
        }

        private RecipeSchema getSchema() {
            if (this.schema == null) {
                if (this.keys != null || this.constructors != null || this.functions != null || this.recipeFactory != null || this.unique != null) {
                    RecipeKey key;
                    List<ConstructorBuilder> constructors;
                    List<RecipeKey<?>> keys = this.getKeys();
                    HashMap keyMap = new HashMap();
                    for (RecipeKey<?> key2 : keys) {
                        keyMap.put(key2.name, key2);
                    }
                    HashMap<String, FunctionBuilder> functionMap = new HashMap<String, FunctionBuilder>();
                    this.gatherFunctions(functionMap);
                    this.schema = new RecipeSchema(this.getKeys().toArray(new RecipeKey[0]));
                    KubeRecipeFactory rf = this.getRecipeFactory();
                    if (rf != null) {
                        this.schema.recipeFactory = rf;
                    }
                    if (!(constructors = this.getConstructors()).isEmpty()) {
                        for (ConstructorBuilder constructorBuilder : constructors) {
                            ArrayList<RecipeKey> cKeys = new ArrayList<RecipeKey>();
                            for (String string : constructorBuilder.keys) {
                                RecipeKey key3 = (RecipeKey)keyMap.get(string);
                                if (key3 != null) {
                                    cKeys.add(key3);
                                    continue;
                                }
                                throw new NullPointerException("Key '" + string + "' not found in constructor of recipe schema '" + String.valueOf(this.id) + "'");
                            }
                            RecipeConstructor constructor = new RecipeConstructor(cKeys.toArray(new RecipeKey[0]));
                            if (!constructorBuilder.overrides.isEmpty()) {
                                constructor.overrides = new IdentityHashMap(constructorBuilder.overrides.size());
                                for (Map.Entry<String, JsonElement> entry : constructorBuilder.overrides.entrySet()) {
                                    key = (RecipeKey)keyMap.get(entry.getKey());
                                    if (key != null) {
                                        try {
                                            constructor.overrides.put(key, new RecipeOptional.Constant<Object>(((Pair)key.codec.decode((DynamicOps)JsonOps.INSTANCE, (Object)entry.getValue()).getOrThrow()).getFirst()));
                                            continue;
                                        }
                                        catch (Exception ex) {
                                            throw new IllegalArgumentException("Failed to create optional value for key '" + String.valueOf(key) + "' of '" + String.valueOf(this.id) + "' from " + String.valueOf(entry.getValue()), ex);
                                        }
                                    }
                                    throw new NullPointerException("Key '" + entry.getKey() + "' not found in overrides of constructor of recipe schema '" + String.valueOf(this.id) + "'");
                                }
                            }
                            this.schema.constructor(constructor);
                        }
                    }
                    for (Map.Entry entry : functionMap.entrySet()) {
                        JsonObject funcJson = ((FunctionBuilder)entry.getValue()).json;
                        if (!funcJson.has("set")) continue;
                        HashMap map = new HashMap(1);
                        for (Map.Entry entry1 : funcJson.getAsJsonObject("set").entrySet()) {
                            key = (RecipeKey)keyMap.get(entry1.getKey());
                            if (key != null) {
                                map.put(key, ((Pair)key.codec.decode((DynamicOps)JsonOps.INSTANCE, (Object)((JsonElement)entry1.getValue())).getOrThrow()).getFirst());
                                continue;
                            }
                            throw new NullPointerException("Key '" + (String)entry1.getKey() + "' not found in function '" + (String)entry1.getKey() + "' of recipe schema '" + String.valueOf(this.id) + "'");
                        }
                        if (map.size() == 1) {
                            this.schema.function((String)entry.getKey(), new RecipeSchemaFunction.SetFunction((RecipeKey)map.keySet().iterator().next(), map.values().iterator().next()));
                            continue;
                        }
                        if (map.isEmpty()) continue;
                        this.schema.function((String)entry.getKey(), new RecipeSchemaFunction.SetManyFunction(map));
                    }
                    List<String> uniqueKeyNames = this.getUnique();
                    if (!uniqueKeyNames.isEmpty()) {
                        ArrayList arrayList = new ArrayList();
                        for (String keyName : uniqueKeyNames) {
                            RecipeKey recipeKey = (RecipeKey)keyMap.get(keyName);
                            if (recipeKey != null) {
                                arrayList.add(recipeKey);
                                continue;
                            }
                            throw new NullPointerException("Key '" + keyName + "' not found in unique keys of recipe schema '" + String.valueOf(this.id) + "'");
                        }
                        this.schema.uniqueIds(arrayList);
                    }
                    this.schema.hidden = this.isHidden();
                } else if (this.parent != null) {
                    this.schema = this.parent.getSchema();
                } else {
                    this.schema = new RecipeSchema(new RecipeKey[0]);
                    this.schema.constructor(new RecipeKey[0]);
                }
            }
            return this.schema;
        }
    }

    private record ConstructorBuilder(List<String> keys, Map<String, JsonElement> overrides) {
    }

    private record FunctionBuilder(String name, JsonObject json) {
    }
}

