/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.recipe.match;

import dev.latvian.mods.kubejs.bindings.IngredientWrapper;
import dev.latvian.mods.kubejs.item.ItemStackSet;
import dev.latvian.mods.kubejs.recipe.RecipeExceptionJS;
import dev.latvian.mods.kubejs.recipe.match.ItemMatch;
import dev.latvian.mods.rhino.Context;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;

public record IngredientMatch(Ingredient ingredient) implements ItemMatch
{
    @Override
    public boolean matches(Context cx, ItemStack item, boolean exact) {
        if (item.isEmpty()) {
            return false;
        }
        if (exact) {
            ItemStackSet stacks = this.ingredient.kjs$getStacks();
            return stacks.size() == 1 && ItemStack.isSameItemSameComponents((ItemStack)stacks.getFirst(), (ItemStack)item);
        }
        return this.ingredient.test(item);
    }

    @Override
    public boolean matches(Context cx, Ingredient in, boolean exact) {
        if (in == Ingredient.EMPTY) {
            return false;
        }
        if (exact) {
            TagKey<Item> t1 = IngredientWrapper.tagKeyOf(this.ingredient);
            TagKey<Item> t2 = IngredientWrapper.tagKeyOf(in);
            if (t1 != null && t2 != null) {
                return t1 == t2;
            }
            return this.ingredient.equals((Object)in);
        }
        try {
            for (ItemStack stack : in.getItems()) {
                if (!this.ingredient.test(stack)) continue;
                return true;
            }
        }
        catch (Exception ex) {
            throw new RecipeExceptionJS("Failed to test ingredient " + String.valueOf(in), ex);
        }
        return false;
    }

    @Override
    public String toString() {
        return this.ingredient.toString();
    }
}

