/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.recipe.match;

import dev.latvian.mods.kubejs.recipe.RecipeExceptionJS;
import dev.latvian.mods.kubejs.recipe.match.FluidMatch;
import dev.latvian.mods.rhino.Context;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.crafting.FluidIngredient;

public record FluidIngredientMatch(FluidIngredient ingredient) implements FluidMatch
{
    @Override
    public boolean matches(Context cx, FluidStack s, boolean exact) {
        return !s.isEmpty() && this.ingredient.test(s);
    }

    @Override
    public boolean matches(Context cx, FluidIngredient in, boolean exact) {
        if (in == FluidIngredient.empty()) {
            return false;
        }
        try {
            for (FluidStack stack : this.ingredient.getStacks()) {
                if (!in.test(stack)) continue;
                return true;
            }
        }
        catch (Exception ex) {
            throw new RecipeExceptionJS("Failed to test fluid ingredient " + String.valueOf(in), ex);
        }
        return false;
    }

    @Override
    public String toString() {
        return this.ingredient.toString();
    }
}

