/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.recipe.component;

import com.google.gson.JsonPrimitive;
import com.mojang.brigadier.StringReader;
import com.mojang.serialization.Codec;
import dev.latvian.mods.kubejs.recipe.KubeRecipe;
import dev.latvian.mods.kubejs.recipe.component.RecipeComponent;
import dev.latvian.mods.kubejs.recipe.component.UniqueIdBuilder;
import dev.latvian.mods.kubejs.recipe.schema.RecipeComponentFactory;
import dev.latvian.mods.kubejs.registry.RegistryType;
import dev.latvian.mods.rhino.Context;
import dev.latvian.mods.rhino.type.TypeInfo;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;

public record TagKeyComponent<T>(ResourceKey<? extends Registry<T>> registry, TypeInfo registryType) implements RecipeComponent<TagKey<T>>
{
    private static final TypeInfo TAG_KEY_TYPE = TypeInfo.of(TagKey.class);
    public static final RecipeComponent<TagKey<Block>> BLOCK = new TagKeyComponent<Block>(Registries.BLOCK, TypeInfo.of(Block.class));
    public static final RecipeComponent<TagKey<Item>> ITEM = new TagKeyComponent<Item>(Registries.ITEM, TypeInfo.of(Item.class));
    public static final RecipeComponent<TagKey<EntityType<?>>> ENTITY_TYPE = new TagKeyComponent(Registries.ENTITY_TYPE, TypeInfo.of(EntityType.class));
    public static final RecipeComponent<TagKey<Biome>> BIOME = new TagKeyComponent<Biome>(Registries.BIOME, TypeInfo.of(Biome.class));
    public static final RecipeComponent<TagKey<Fluid>> FLUID = new TagKeyComponent<Fluid>(Registries.FLUID, TypeInfo.of(Fluid.class));
    public static final RecipeComponentFactory FACTORY = (storage, reader) -> {
        reader.skipWhitespace();
        reader.expect('<');
        reader.skipWhitespace();
        ResourceKey registry = ResourceKey.createRegistryKey((ResourceLocation)ResourceLocation.read((StringReader)reader));
        reader.expect('>');
        RegistryType<?> r = RegistryType.ofKey(registry);
        return new TagKeyComponent(registry, r != null ? r.type() : TypeInfo.NONE);
    };

    @Override
    public Codec<TagKey<T>> codec() {
        return TagKey.codec(this.registry);
    }

    @Override
    public TypeInfo typeInfo() {
        return this.registryType.shouldConvert() ? TAG_KEY_TYPE : TAG_KEY_TYPE.withParams(new TypeInfo[]{this.registryType});
    }

    @Override
    public TagKey<T> wrap(Context cx, KubeRecipe recipe, Object from) {
        String s;
        if (from instanceof TagKey) {
            TagKey k = (TagKey)from;
            return k;
        }
        if (from instanceof JsonPrimitive) {
            JsonPrimitive json = (JsonPrimitive)from;
            v0 = json.getAsString();
        } else {
            v0 = s = String.valueOf(from);
        }
        if (s.startsWith("#")) {
            s = s.substring(1);
        }
        return TagKey.create(this.registry, (ResourceLocation)ResourceLocation.parse((String)s));
    }

    @Override
    public boolean hasPriority(Context cx, KubeRecipe recipe, Object from) {
        JsonPrimitive json;
        return from instanceof TagKey || from instanceof CharSequence && from.toString().startsWith("#") || from instanceof JsonPrimitive && (json = (JsonPrimitive)from).isString() && json.getAsString().startsWith("#");
    }

    @Override
    public void buildUniqueId(UniqueIdBuilder builder, TagKey<T> value) {
        builder.append(value.location());
    }

    @Override
    public String toString() {
        ResourceKey<? extends Registry<T>> key = this.registry;
        if (key == Registries.BLOCK) {
            return "block_tag";
        }
        if (key == Registries.ITEM) {
            return "item_tag";
        }
        if (key == Registries.ENTITY_TYPE) {
            return "entity_type_tag";
        }
        if (key == Registries.BIOME) {
            return "biome_tag";
        }
        if (key == Registries.FLUID) {
            return "fluid_tag";
        }
        return "tag<" + String.valueOf(key.location()) + ">";
    }
}

