/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.recipe.component;

import com.google.gson.JsonPrimitive;
import com.mojang.brigadier.StringReader;
import com.mojang.serialization.Codec;
import dev.latvian.mods.kubejs.fluid.FluidWrapper;
import dev.latvian.mods.kubejs.item.ItemStackJS;
import dev.latvian.mods.kubejs.recipe.KubeRecipe;
import dev.latvian.mods.kubejs.recipe.component.RecipeComponent;
import dev.latvian.mods.kubejs.recipe.component.UniqueIdBuilder;
import dev.latvian.mods.kubejs.recipe.schema.RecipeComponentFactory;
import dev.latvian.mods.kubejs.registry.RegistryInfo;
import dev.latvian.mods.kubejs.registry.RegistryType;
import dev.latvian.mods.kubejs.script.KubeJSContext;
import dev.latvian.mods.kubejs.util.ID;
import dev.latvian.mods.rhino.Context;
import dev.latvian.mods.rhino.type.TypeInfo;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;

public record RegistryComponent<T>(RegistryInfo<T> registry) implements RecipeComponent<T>
{
    public static final RecipeComponentFactory FACTORY = (storage, reader) -> {
        reader.skipWhitespace();
        reader.expect('<');
        reader.skipWhitespace();
        ResourceLocation regId = ResourceLocation.read((StringReader)reader);
        reader.expect('>');
        return new RegistryComponent(RegistryInfo.of(ResourceKey.createRegistryKey((ResourceLocation)regId)));
    };

    @Override
    public Codec<T> codec() {
        return this.registry.valueByNameCodec();
    }

    @Override
    public TypeInfo typeInfo() {
        RegistryType t = RegistryType.ofKey(this.registry.key);
        return t == null || t.type() == TypeInfo.STRING ? TypeInfo.STRING : TypeInfo.STRING.or(t.type());
    }

    @Override
    public T wrap(Context cx, KubeRecipe recipe, Object from) {
        if (this.registry == RegistryInfo.ITEM) {
            if (from instanceof ItemStack) {
                ItemStack is = (ItemStack)from;
                return (T)is.getItem();
            }
            if (from instanceof Item) {
                return (T)from;
            }
            return (T)ItemStackJS.wrap(((KubeJSContext)cx).getRegistries(), from).getItem();
        }
        if (this.registry == RegistryInfo.FLUID) {
            if (from instanceof FluidStack) {
                FluidStack fs = (FluidStack)from;
                return (T)fs.getFluid();
            }
            if (from instanceof Fluid) {
                return (T)from;
            }
            return (T)FluidWrapper.wrap(((KubeJSContext)cx).getRegistries(), from).getFluid();
        }
        RegistryType regType = RegistryType.ofKey(this.registry.key);
        if (regType != null && regType.baseClass().isInstance(from)) {
            return (T)from;
        }
        return this.registry.getValue(ID.mc(from));
    }

    @Override
    public boolean hasPriority(Context cx, KubeRecipe recipe, Object from) {
        JsonPrimitive json;
        RegistryType regType = RegistryType.ofKey(this.registry.key);
        return regType != null && regType.baseClass().isInstance(from) || from instanceof CharSequence && ID.mc(from.toString()) != null || from instanceof JsonPrimitive && (json = (JsonPrimitive)from).isString() && ID.mc(json.getAsString()) != null;
    }

    @Override
    public void buildUniqueId(UniqueIdBuilder builder, T value) {
        ResourceLocation id = this.registry.getId(value);
        if (id != null) {
            builder.append(id);
        }
    }

    @Override
    public String toString() {
        return "registry_element<" + String.valueOf(this.registry) + ">";
    }
}

