/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.recipe.component;

import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.RecordBuilder;
import dev.latvian.mods.kubejs.recipe.KubeRecipe;
import dev.latvian.mods.kubejs.recipe.RecipeKey;
import dev.latvian.mods.kubejs.recipe.component.RecipeComponent;
import dev.latvian.mods.kubejs.recipe.component.RecipeComponentBuilderMap;
import dev.latvian.mods.kubejs.recipe.component.RecipeComponentValue;
import dev.latvian.mods.kubejs.recipe.component.UniqueIdBuilder;
import dev.latvian.mods.kubejs.recipe.match.ReplacementMatchInfo;
import dev.latvian.mods.kubejs.util.Cast;
import dev.latvian.mods.rhino.Context;
import dev.latvian.mods.rhino.type.JSObjectTypeInfo;
import dev.latvian.mods.rhino.type.JSOptionalParam;
import dev.latvian.mods.rhino.type.TypeInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class RecipeComponentBuilder
implements RecipeComponent<RecipeComponentBuilderMap> {
    public final List<RecipeKey<?>> keys;
    public Predicate<Set<String>> hasPriority;

    public RecipeComponentBuilder(int init) {
        this.keys = new ArrayList(init);
    }

    public RecipeComponentBuilder add(RecipeKey<?> key) {
        this.keys.add(key);
        return this;
    }

    public RecipeComponentBuilder hasPriority(Predicate<Set<String>> hasPriority) {
        this.hasPriority = hasPriority;
        return this;
    }

    public RecipeComponentBuilder createCopy() {
        RecipeComponentBuilder copy = new RecipeComponentBuilder(this.keys.size());
        copy.keys.addAll(this.keys);
        copy.hasPriority = this.hasPriority;
        return copy;
    }

    @Override
    public Codec<RecipeComponentBuilderMap> codec() {
        return new Codec<RecipeComponentBuilderMap>(this){

            public <T> DataResult<Pair<RecipeComponentBuilderMap, T>> decode(DynamicOps<T> ops, T input) {
                return DataResult.error(() -> "I don't understand codecs well enough yet");
            }

            public <T> DataResult<T> encode(RecipeComponentBuilderMap input, DynamicOps<T> ops, T prefix) {
                RecordBuilder builder = ops.mapBuilder();
                return builder.build(prefix);
            }
        };
    }

    @Override
    public TypeInfo typeInfo() {
        ArrayList<JSOptionalParam> list = new ArrayList<JSOptionalParam>(this.keys.size());
        for (RecipeKey<?> key : this.keys) {
            list.add(new JSOptionalParam(key.name, key.component.typeInfo(), key.optional()));
        }
        return new JSObjectTypeInfo(list);
    }

    @Override
    public boolean hasPriority(Context cx, KubeRecipe recipe, Object from) {
        if (from instanceof Map) {
            Map m = (Map)from;
            if (this.hasPriority != null) {
                return this.hasPriority.test(m.keySet());
            }
            for (RecipeKey<?> key : this.keys) {
                if (key.optional() || m.containsKey(key.name)) continue;
                return false;
            }
            return true;
        }
        if (from instanceof JsonObject) {
            JsonObject json = (JsonObject)from;
            if (this.hasPriority != null) {
                return this.hasPriority.test(json.keySet());
            }
            for (RecipeKey<?> key : this.keys) {
                if (key.optional() || json.has(key.name)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean matches(Context cx, KubeRecipe recipe, RecipeComponentBuilderMap value, ReplacementMatchInfo match) {
        for (RecipeComponentValue<?> e : value.holders) {
            if (!e.matches(cx, recipe, match)) continue;
            return true;
        }
        return false;
    }

    @Override
    public RecipeComponentBuilderMap replace(Context cx, KubeRecipe recipe, RecipeComponentBuilderMap original, ReplacementMatchInfo match, Object with) {
        for (RecipeComponentValue<?> e : original.holders) {
            if (!e.replace(cx, recipe, match, with)) continue;
            original.hasChanged = true;
        }
        return original;
    }

    @Override
    public void buildUniqueId(UniqueIdBuilder builder, RecipeComponentBuilderMap value) {
        boolean first = true;
        for (Map.Entry<RecipeKey<?>, Object> entry : value.entrySet()) {
            if (entry.getValue() == null) continue;
            if (first) {
                first = false;
            } else {
                builder.appendSeparator();
            }
            entry.getKey().component.buildUniqueId(builder, Cast.to(entry.getValue()));
        }
    }

    public String toString() {
        return this.keys.stream().map(RecipeKey::toString).collect(Collectors.joining(", ", "builder<", ">"));
    }

    @Override
    public boolean checkValueHasChanged(RecipeComponentBuilderMap oldValue, RecipeComponentBuilderMap newValue) {
        return newValue.hasChanged;
    }
}

