/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.recipe.component;

import com.google.gson.JsonObject;
import com.mojang.serialization.Codec;
import dev.latvian.mods.kubejs.recipe.KubeRecipe;
import dev.latvian.mods.kubejs.recipe.RecipeKey;
import dev.latvian.mods.kubejs.recipe.component.CharacterComponent;
import dev.latvian.mods.kubejs.recipe.component.IngredientComponent;
import dev.latvian.mods.kubejs.recipe.component.RecipeComponent;
import dev.latvian.mods.kubejs.recipe.component.UniqueIdBuilder;
import dev.latvian.mods.kubejs.recipe.match.ReplacementMatchInfo;
import dev.latvian.mods.kubejs.recipe.schema.RecipeComponentFactory;
import dev.latvian.mods.kubejs.util.TinyMap;
import dev.latvian.mods.rhino.Context;
import dev.latvian.mods.rhino.type.TypeInfo;
import java.util.Map;
import net.minecraft.world.item.crafting.Ingredient;

public record MapRecipeComponent<K, V>(RecipeComponent<K> key, RecipeComponent<V> component, boolean patternKey) implements RecipeComponent<TinyMap<K, V>>
{
    public static final MapRecipeComponent<Character, Ingredient> INGREDIENT_PATTERN_KEY = new MapRecipeComponent<Character, Ingredient>(CharacterComponent.CHARACTER, IngredientComponent.INGREDIENT, true);
    public static final RecipeComponentFactory FACTORY = RecipeComponentFactory.readTwoComponents((key, component) -> {
        if (key == CharacterComponent.CHARACTER && component == MapRecipeComponent.INGREDIENT_PATTERN_KEY.component) {
            return INGREDIENT_PATTERN_KEY;
        }
        return new MapRecipeComponent(key, component, false);
    });
    public static final RecipeComponentFactory PATTERN_FACTORY = RecipeComponentFactory.readOneComponent(component -> {
        if (component == MapRecipeComponent.INGREDIENT_PATTERN_KEY.component) {
            return INGREDIENT_PATTERN_KEY;
        }
        return new MapRecipeComponent(CharacterComponent.CHARACTER, component, true);
    });

    @Override
    public Codec<TinyMap<K, V>> codec() {
        return Codec.unboundedMap(this.key.codec(), this.component.codec()).xmap(TinyMap::ofMap, TinyMap::toMap);
    }

    @Override
    public TypeInfo typeInfo() {
        return TypeInfo.RAW_MAP.withParams(new TypeInfo[]{this.key.typeInfo(), this.component.typeInfo()});
    }

    @Override
    public TinyMap<K, V> wrap(Context cx, KubeRecipe recipe, Object from) {
        if (from instanceof TinyMap) {
            TinyMap map = (TinyMap)from;
            return map;
        }
        if (from instanceof JsonObject) {
            JsonObject o = (JsonObject)from;
            TinyMap map = new TinyMap(new TinyMap.Entry[o.size()]);
            int i = 0;
            for (Map.Entry entry : o.entrySet()) {
                K k = this.key.wrap(cx, recipe, entry.getKey());
                V v = this.component.wrap(cx, recipe, entry.getValue());
                map.entries()[i++] = new TinyMap.Entry<K, V>(k, v);
            }
            return map;
        }
        if (from instanceof Map) {
            Map m = (Map)from;
            TinyMap map = new TinyMap(new TinyMap.Entry[m.size()]);
            int i = 0;
            for (Map.Entry entry : m.entrySet()) {
                K k = this.key.wrap(cx, recipe, entry.getKey());
                V v = this.component.wrap(cx, recipe, entry.getValue());
                map.entries()[i++] = new TinyMap.Entry<K, V>(k, v);
            }
            return map;
        }
        throw new IllegalArgumentException("Expected JSON object!");
    }

    @Override
    public String checkEmpty(RecipeKey<TinyMap<K, V>> key, TinyMap<K, V> value) {
        if (value.isEmpty()) {
            return "Map '" + key.name + "' can't be empty!";
        }
        return "";
    }

    @Override
    public boolean matches(Context cx, KubeRecipe recipe, TinyMap<K, V> value, ReplacementMatchInfo match) {
        for (TinyMap.Entry<K, V> entry : value.entries()) {
            if (!this.component.matches(cx, recipe, entry.value(), match)) continue;
            return true;
        }
        return false;
    }

    @Override
    public TinyMap<K, V> replace(Context cx, KubeRecipe recipe, TinyMap<K, V> original, ReplacementMatchInfo match, Object with) {
        TinyMap<K, V> map = original;
        for (int i = 0; i < original.entries().length; ++i) {
            V r = this.component.replace(cx, recipe, original.entries()[i].value(), match, with);
            if (r == original.entries()[i].value()) continue;
            if (map == original) {
                map = new TinyMap<K, V>(original);
            }
            map.entries()[i] = new TinyMap.Entry<K, V>(original.entries()[i].key(), r);
        }
        return map;
    }

    @Override
    public void buildUniqueId(UniqueIdBuilder builder, TinyMap<K, V> value) {
        boolean first = true;
        for (TinyMap.Entry<K, V> entry : value.entries()) {
            if (entry.value() == null) continue;
            if (first) {
                first = false;
            } else {
                builder.appendSeparator();
            }
            this.component.buildUniqueId(builder, entry.value());
        }
    }

    @Override
    public String toString() {
        if (this.patternKey) {
            return "pattern<" + String.valueOf(this.component) + ">";
        }
        return "map<" + String.valueOf(this.key) + ", " + String.valueOf(this.component) + ">";
    }
}

