/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.recipe.component;

import com.mojang.serialization.Codec;
import dev.latvian.mods.kubejs.recipe.RecipeExceptionJS;
import dev.latvian.mods.kubejs.recipe.component.RecipeComponent;
import dev.latvian.mods.kubejs.recipe.component.UniqueIdBuilder;
import dev.latvian.mods.kubejs.recipe.schema.RecipeComponentFactory;
import dev.latvian.mods.rhino.type.EnumTypeInfo;
import dev.latvian.mods.rhino.type.TypeInfo;
import dev.latvian.mods.rhino.util.RemappedEnumConstant;

public record EnumComponent<T extends Enum<T>>(EnumTypeInfo enumTypeInfo, Codec<T> codec) implements RecipeComponent<T>
{
    public static final RecipeComponentFactory FACTORY = (storage, reader) -> {
        reader.skipWhitespace();
        reader.expect('<');
        reader.skipWhitespace();
        String cname = reader.readStringUntil('>').trim();
        reader.expect('>');
        try {
            if (cname == null) {
                throw new NullPointerException();
            }
            Class<?> clazz = Class.forName(cname);
            TypeInfo typeInfo = TypeInfo.of(clazz);
            if (!(typeInfo instanceof EnumTypeInfo)) {
                throw new RecipeExceptionJS("Class " + clazz.getTypeName() + " is not an enum!");
            }
            EnumTypeInfo enumTypeInfo = (EnumTypeInfo)typeInfo;
            return new EnumComponent(enumTypeInfo, Codec.STRING.xmap(s -> {
                for (Object c : enumTypeInfo.enumConstants()) {
                    Enum e;
                    RemappedEnumConstant r;
                    if (c instanceof RemappedEnumConstant && (r = (RemappedEnumConstant)c).getRemappedEnumConstantName().equalsIgnoreCase((String)s)) {
                        return c;
                    }
                    if (!(c instanceof Enum) || !(e = (Enum)c).name().equalsIgnoreCase((String)s)) continue;
                    return c;
                }
                throw new RecipeExceptionJS("Enum value '" + s + "' of " + clazz.getName() + " not found");
            }, EnumTypeInfo::getName));
        }
        catch (Exception ex) {
            throw new RecipeExceptionJS("Error loading class " + cname + " for EnumComponent", ex);
        }
    };

    @Override
    public TypeInfo typeInfo() {
        return this.enumTypeInfo;
    }

    @Override
    public void buildUniqueId(UniqueIdBuilder builder, T value) {
        if (value instanceof RemappedEnumConstant) {
            RemappedEnumConstant r = (RemappedEnumConstant)value;
            builder.append(r.getRemappedEnumConstantName());
        } else if (value instanceof Enum) {
            T e = value;
            builder.append(((Enum)e).name());
        } else {
            builder.append(((Enum)value).toString());
        }
    }

    @Override
    public String toString() {
        return "enum<" + this.enumTypeInfo.asClass().getName() + ">";
    }
}

