/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.recipe.component;

import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import dev.latvian.mods.kubejs.recipe.KubeRecipe;
import dev.latvian.mods.kubejs.recipe.RecipeExceptionJS;
import dev.latvian.mods.kubejs.recipe.component.RecipeComponent;
import dev.latvian.mods.kubejs.recipe.component.UniqueIdBuilder;
import dev.latvian.mods.kubejs.recipe.match.ReplacementMatchInfo;
import dev.latvian.mods.kubejs.recipe.schema.RecipeComponentFactory;
import dev.latvian.mods.kubejs.script.ConsoleJS;
import dev.latvian.mods.rhino.Context;
import dev.latvian.mods.rhino.type.TypeInfo;
import java.util.Optional;

public record EitherRecipeComponent<H, L>(RecipeComponent<H> high, RecipeComponent<L> low) implements RecipeComponent<Either<H, L>>
{
    public static final RecipeComponentFactory FACTORY = RecipeComponentFactory.readTwoComponents(EitherRecipeComponent::new);

    @Override
    public Codec<Either<H, L>> codec() {
        return Codec.either(this.high.codec(), this.low.codec());
    }

    @Override
    public TypeInfo typeInfo() {
        return this.high.typeInfo().or(this.low.typeInfo());
    }

    @Override
    public Either<H, L> wrap(Context cx, KubeRecipe recipe, Object from) {
        if (this.high.hasPriority(cx, recipe, from)) {
            return Either.left(this.high.wrap(cx, recipe, from));
        }
        if (this.low.hasPriority(cx, recipe, from)) {
            return Either.right(this.low.wrap(cx, recipe, from));
        }
        try {
            return Either.left(this.high.wrap(cx, recipe, from));
        }
        catch (Exception ex1) {
            try {
                return Either.right(this.low.wrap(cx, recipe, from));
            }
            catch (Exception ex2) {
                ConsoleJS.SERVER.error("Failed to read %s as high priority (%s)!".formatted(from, this.high), ex1);
                ConsoleJS.SERVER.error("Failed to read %s as low priority (%s)!".formatted(from, this.low), ex2);
                throw new RecipeExceptionJS("Failed to read %s as either %s or %s!".formatted(from, this.high, this.low));
            }
        }
    }

    @Override
    public boolean matches(Context cx, KubeRecipe recipe, Either<H, L> value, ReplacementMatchInfo match) {
        Optional l = value.left();
        return l.isPresent() ? this.high.matches(cx, recipe, l.get(), match) : this.low.matches(cx, recipe, value.right().get(), match);
    }

    @Override
    public Either<H, L> replace(Context cx, KubeRecipe recipe, Either<H, L> original, ReplacementMatchInfo match, Object with) {
        Optional l = original.left();
        if (l.isPresent()) {
            H r = this.high.replace(cx, recipe, l.get(), match, with);
            return r == l.get() ? original : Either.left(r);
        }
        L r = this.low.replace(cx, recipe, original.right().get(), match, with);
        return r == original.right().get() ? original : Either.right(r);
    }

    @Override
    public boolean checkValueHasChanged(Either<H, L> oldValue, Either<H, L> newValue) {
        Optional left;
        if (oldValue != null && newValue != null && ((left = oldValue.left()).isPresent() ? this.high.checkValueHasChanged(left.get(), newValue.left().get()) : this.low.checkValueHasChanged(oldValue.right().get(), newValue.right().get()))) {
            return true;
        }
        return oldValue != newValue;
    }

    @Override
    public void buildUniqueId(UniqueIdBuilder builder, Either<H, L> value) {
        Optional left = value.left();
        if (left.isPresent()) {
            this.high.buildUniqueId(builder, left.get());
        } else {
            this.low.buildUniqueId(builder, value.right().get());
        }
    }

    @Override
    public String toString() {
        return "either<" + String.valueOf(this.high) + ", " + String.valueOf(this.low) + ">";
    }
}

