/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapLike;
import dev.latvian.mods.kubejs.recipe.RecipesKubeEvent;
import dev.latvian.mods.kubejs.script.ConsoleJS;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.neoforged.neoforge.common.conditions.ConditionalOps;
import org.jetbrains.annotations.Nullable;

public interface RecipeHelper {
    @Nullable
    public static RecipeHolder<?> fromJson(DynamicOps<JsonElement> ops, RecipeSerializer<?> serializer, ResourceLocation id, JsonObject json, boolean errors) {
        block10: {
            MapCodec codec = serializer.codec();
            if (codec == null) {
                if (errors) {
                    ConsoleJS.SERVER.error("Error parsing recipe " + String.valueOf(id) + ": Codec not found in " + serializer.getClass().getName());
                }
                return null;
            }
            Optional map = ops.getMap((Object)json).result();
            if (map.isEmpty()) {
                if (errors) {
                    ConsoleJS.SERVER.error("Error parsing recipe " + String.valueOf(id) + ": Couldn't convert " + String.valueOf(json) + " to a map");
                }
                return null;
            }
            try {
                DataResult recipe = codec.decode(ops, (MapLike)map.get());
                if (recipe.error().isPresent()) {
                    if (errors) {
                        ConsoleJS.SERVER.error("Error parsing recipe " + String.valueOf(id) + ": " + ((DataResult.Error)recipe.error().get()).message());
                    }
                } else if (recipe.isSuccess()) {
                    return new RecipeHolder(id, (Recipe)recipe.getOrThrow());
                }
            }
            catch (Exception e) {
                if (!errors) break block10;
                ConsoleJS.SERVER.error("Error parsing recipe " + String.valueOf(id) + " from " + String.valueOf(map.get()), e, RecipesKubeEvent.CREATE_RECIPE_SKIP_ERROR);
            }
        }
        return null;
    }

    public static DataResult<JsonObject> validate(DynamicOps<JsonElement> ops, JsonElement jsonElement) {
        if (!jsonElement.isJsonObject()) {
            return DataResult.error(() -> "not a json object: " + String.valueOf(jsonElement));
        }
        JsonObject json = GsonHelper.convertToJsonObject((JsonElement)jsonElement, (String)"top element");
        if (!json.has("type")) {
            return DataResult.error(() -> "missing type");
        }
        Codec codec = ConditionalOps.createConditionalCodec((Codec)Codec.unit((Object)json));
        return codec.parse(ops, (Object)json).mapError(str -> "error while parsing conditions: " + str).flatMap(optional -> optional.map(DataResult::success).orElseGet(() -> DataResult.error(() -> "conditions not met")));
    }
}

