/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import dev.latvian.mods.kubejs.CommonProperties;
import dev.latvian.mods.kubejs.DevProperties;
import dev.latvian.mods.kubejs.core.RecipeLikeKJS;
import dev.latvian.mods.kubejs.recipe.RecipeExceptionJS;
import dev.latvian.mods.kubejs.recipe.RecipeFunction;
import dev.latvian.mods.kubejs.recipe.RecipeHelper;
import dev.latvian.mods.kubejs.recipe.RecipeKey;
import dev.latvian.mods.kubejs.recipe.RecipeTypeFunction;
import dev.latvian.mods.kubejs.recipe.RecipesKubeEvent;
import dev.latvian.mods.kubejs.recipe.component.MissingComponentException;
import dev.latvian.mods.kubejs.recipe.component.RecipeComponentBuilderMap;
import dev.latvian.mods.kubejs.recipe.component.RecipeComponentValue;
import dev.latvian.mods.kubejs.recipe.ingredientaction.ConsumeAction;
import dev.latvian.mods.kubejs.recipe.ingredientaction.CustomIngredientAction;
import dev.latvian.mods.kubejs.recipe.ingredientaction.DamageAction;
import dev.latvian.mods.kubejs.recipe.ingredientaction.IngredientAction;
import dev.latvian.mods.kubejs.recipe.ingredientaction.IngredientActionHolder;
import dev.latvian.mods.kubejs.recipe.ingredientaction.KeepAction;
import dev.latvian.mods.kubejs.recipe.ingredientaction.ReplaceAction;
import dev.latvian.mods.kubejs.recipe.match.ReplacementMatchInfo;
import dev.latvian.mods.kubejs.recipe.schema.RecipeSchema;
import dev.latvian.mods.kubejs.script.ConsoleJS;
import dev.latvian.mods.kubejs.util.Cast;
import dev.latvian.mods.kubejs.util.SlotFilter;
import dev.latvian.mods.kubejs.util.UtilsJS;
import dev.latvian.mods.rhino.Context;
import dev.latvian.mods.rhino.Scriptable;
import dev.latvian.mods.rhino.Wrapper;
import dev.latvian.mods.rhino.type.TypeInfo;
import dev.latvian.mods.rhino.util.CustomJavaToJsWrapper;
import dev.latvian.mods.rhino.util.HideFromJS;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.neoforged.fml.loading.FMLLoader;
import org.apache.commons.lang3.mutable.MutableObject;
import org.jetbrains.annotations.Nullable;

public class KubeRecipe
implements RecipeLikeKJS,
CustomJavaToJsWrapper {
    public ResourceLocation id;
    public RecipeTypeFunction type;
    public boolean newRecipe;
    public boolean removed;
    public String modifyResult = "";
    private RecipeComponentBuilderMap valueMap = RecipeComponentBuilderMap.EMPTY;
    private RecipeComponentValue<?>[] inputValues;
    private RecipeComponentValue<?>[] outputValues;
    public JsonObject originalJson = null;
    private MutableObject<Recipe<?>> originalRecipe = null;
    public JsonObject json = null;
    public boolean changed = false;
    protected List<IngredientActionHolder> recipeIngredientActions;

    public final Scriptable convertJavaToJs(Context cx, Scriptable scope, TypeInfo staticType) {
        return new RecipeFunction(cx, scope, staticType, this);
    }

    public void deserialize(boolean merge) {
        for (RecipeComponentValue<?> v : this.valueMap.holders) {
            try {
                v.key.component.readFromJson(this, (RecipeComponentValue)Cast.to(v), this.json);
            }
            catch (Exception ex) {
                ConsoleJS.SERVER.error("Failed to read " + String.valueOf(v.key) + " from recipe " + String.valueOf(this), ex, RecipesKubeEvent.POST_SKIP_ERROR);
            }
            if (v.value != null) {
                if (!merge) continue;
                v.write();
                continue;
            }
            if (v.key.optional()) continue;
            throw new MissingComponentException(v.key.name, v.key, this.valueMap.keySet());
        }
    }

    public void serialize() {
        for (RecipeComponentValue<?> v : this.valueMap.holders) {
            if (!v.shouldWrite()) continue;
            if (v.value == null) {
                throw new RecipeExceptionJS("Value not set for " + String.valueOf(v.key) + " in recipe " + String.valueOf(this));
            }
            v.key.component.writeToJson(this, (RecipeComponentValue)Cast.to(v), this.json);
        }
    }

    public <T> T getValue(RecipeKey<T> key) {
        RecipeComponentValue<?> v = this.valueMap.getHolder(key);
        if (v == null) {
            throw new MissingComponentException(key.name, key, this.valueMap.keySet());
        }
        return Cast.to(v.value);
    }

    public <T> KubeRecipe setValue(RecipeKey<T> key, T value) {
        RecipeComponentValue v = (RecipeComponentValue)Cast.to(this.valueMap.getHolder(key));
        if (v == null) {
            throw new MissingComponentException(key.name, key, this.valueMap.keySet());
        }
        v.value = value;
        v.write();
        this.save();
        return this;
    }

    @Nullable
    public Object get(String key) {
        for (RecipeComponentValue<?> h : this.valueMap.holders) {
            for (String name : h.key.names) {
                if (!name.equals(key)) continue;
                return h.value;
            }
        }
        throw new MissingComponentException(key, null, this.valueMap.keySet());
    }

    public KubeRecipe set(Context cx, String key, Object value) {
        for (RecipeComponentValue<?> h : this.valueMap.holders) {
            for (String name : h.key.names) {
                if (!name.equals(key)) continue;
                h.value = Cast.to(h.key.component.wrap(cx, this, Wrapper.unwrapped((Object)value)));
                h.write();
                this.save();
                return this;
            }
        }
        throw new MissingComponentException(key, null, this.valueMap.keySet());
    }

    public void initValues(boolean created) {
        if (created) {
            this.save();
        }
        if (this.type.schemaType.schema.keys.length > 0) {
            this.valueMap = new RecipeComponentBuilderMap(this.type.schemaType.schema.keys);
            if (created) {
                for (RecipeComponentValue<?> v : this.valueMap.holders) {
                    if (!v.key.alwaysWrite && v.key.optional()) continue;
                    if (v.key.alwaysWrite) {
                        v.value = Cast.to(v.key.optional.getDefaultValue(this.type.schemaType));
                    }
                    v.write();
                }
            }
        }
    }

    @HideFromJS
    public RecipeComponentValue<?>[] getRecipeComponentValues() {
        return this.valueMap.holders;
    }

    public void afterLoaded() {
        for (RecipeComponentValue<?> v : this.valueMap.holders) {
            String e = v.checkEmpty();
            if (e.isEmpty()) continue;
            throw new RecipeExceptionJS(e);
        }
    }

    public final void save() {
        this.changed = true;
    }

    public KubeRecipe id(ResourceLocation id) {
        this.id = id;
        this.save();
        return this;
    }

    public KubeRecipe group(String g) {
        this.kjs$setGroup(g);
        return this;
    }

    public KubeRecipe merge(JsonObject j) {
        if (j != null && j.size() > 0) {
            for (Map.Entry entry : j.entrySet()) {
                this.json.add((String)entry.getKey(), (JsonElement)entry.getValue());
            }
            this.save();
            this.deserialize(true);
        }
        return this;
    }

    public final boolean hasChanged() {
        if (this.changed) {
            return true;
        }
        for (RecipeComponentValue<?> vc : this.valueMap.holders) {
            if (!vc.shouldWrite()) continue;
            return true;
        }
        return false;
    }

    @Override
    @Deprecated
    public final String kjs$getGroup() {
        JsonElement e = this.json.get("group");
        return e instanceof JsonPrimitive ? e.getAsString() : "";
    }

    @Override
    @Deprecated
    public final void kjs$setGroup(String group) {
        if (!this.kjs$getGroup().equals(group)) {
            if (group.isEmpty()) {
                this.json.remove("group");
            } else {
                this.json.addProperty("group", group);
            }
            this.save();
        }
    }

    @Override
    @Deprecated
    public final ResourceLocation kjs$getOrCreateId() {
        return this.getOrCreateId();
    }

    @Override
    @Deprecated
    public final RecipeSchema kjs$getSchema(Context cx) {
        return this.type.schemaType.schema;
    }

    @Override
    @Deprecated
    public final ResourceLocation kjs$getType() {
        return this.getType();
    }

    @Override
    public RecipeSerializer<?> kjs$getSerializer() {
        return this.type.schemaType.getSerializer();
    }

    public final RecipeComponentValue<?>[] inputValues() {
        if (this.inputValues == null) {
            if (this.type.schemaType.schema.inputCount() == 0) {
                this.inputValues = (RecipeComponentValue[])Cast.to(RecipeComponentValue.EMPTY_ARRAY);
            } else {
                ArrayList list = new ArrayList(this.type.schemaType.schema.inputCount());
                for (RecipeComponentValue<?> v : this.valueMap.holders) {
                    if (!v.key.role.isInput()) continue;
                    list.add(v);
                }
                this.inputValues = list.toArray(new RecipeComponentValue[list.size()]);
            }
        }
        return this.inputValues;
    }

    public final RecipeComponentValue<?>[] outputValues() {
        if (this.outputValues == null) {
            if (this.type.schemaType.schema.outputCount() == 0) {
                this.outputValues = (RecipeComponentValue[])Cast.to(RecipeComponentValue.EMPTY_ARRAY);
            } else {
                ArrayList list = new ArrayList(this.type.schemaType.schema.outputCount());
                for (RecipeComponentValue<?> v : this.valueMap.holders) {
                    if (!v.key.role.isOutput()) continue;
                    list.add(v);
                }
                this.outputValues = list.toArray(new RecipeComponentValue[list.size()]);
            }
        }
        return this.outputValues;
    }

    @Override
    public boolean hasInput(Context cx, ReplacementMatchInfo match) {
        for (RecipeComponentValue<?> v : this.inputValues()) {
            if (!v.matches(cx, this, match)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean replaceInput(Context cx, ReplacementMatchInfo match, Object with) {
        boolean replaced = false;
        for (RecipeComponentValue<?> v : this.inputValues()) {
            replaced = v.replace(cx, this, match, with) || replaced;
        }
        if (replaced) {
            this.save();
        }
        return replaced;
    }

    @Override
    public boolean hasOutput(Context cx, ReplacementMatchInfo match) {
        for (RecipeComponentValue<?> v : this.outputValues()) {
            if (!v.matches(cx, this, match)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean replaceOutput(Context cx, ReplacementMatchInfo match, Object with) {
        boolean replaced = false;
        for (RecipeComponentValue<?> v : this.outputValues()) {
            replaced = v.replace(cx, this, match, with) || replaced;
        }
        if (replaced) {
            this.save();
        }
        return replaced;
    }

    public String toString() {
        if (this.id == null && this.json == null) {
            return "<no id> [" + String.valueOf(this.type) + "]";
        }
        return String.valueOf(this.getOrCreateId()) + "[" + String.valueOf(this.type) + "]";
    }

    public String getId() {
        return this.getOrCreateId().toString();
    }

    public String getPath() {
        return this.getOrCreateId().getPath();
    }

    @HideFromJS
    public ResourceLocation getType() {
        return this.type.id;
    }

    @HideFromJS
    public ResourceLocation getOrCreateId() {
        if (this.id == null) {
            RecipeTypeFunction js = this.getSerializationTypeFunction();
            String ids = CommonProperties.get().ignoreCustomUniqueRecipeIds ? null : js.schemaType.schema.uniqueIdFunction.apply(this);
            String prefix = js.id.getNamespace() + ":kjs/";
            ids = ids == null || ids.isEmpty() ? UtilsJS.getUniqueId((JsonElement)this.json) : ids.replace(':', '_');
            this.id = this.type.event.takeId(this, prefix, ids);
        }
        return this.id;
    }

    public String getFromToString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        for (RecipeComponentValue<?> v : this.inputValues()) {
            if (sb.length() > 1) {
                sb.append(",");
            }
            sb.append(v.value);
        }
        sb.append("] -> [");
        for (RecipeComponentValue<?> v : this.outputValues()) {
            if (sb.length() > 1) {
                sb.append(",");
            }
            sb.append(v.value);
        }
        return sb.append(']').toString();
    }

    public final void remove() {
        if (!this.removed) {
            this.removed = true;
            if (DevProperties.get().logRemovedRecipes) {
                ConsoleJS.SERVER.info("- " + String.valueOf(this) + ": " + this.getFromToString());
            } else if (ConsoleJS.SERVER.shouldPrintDebug()) {
                ConsoleJS.SERVER.debug("- " + String.valueOf(this) + ": " + this.getFromToString());
            }
        }
    }

    public KubeRecipe stage(String s) {
        this.json.addProperty("kubejs:stage", s);
        this.save();
        return this;
    }

    public RecipeTypeFunction getSerializationTypeFunction() {
        return this.type;
    }

    @Nullable
    public RecipeHolder<?> createRecipe() {
        if (this.removed) {
            return null;
        }
        if (this.newRecipe || this.hasChanged()) {
            this.serialize();
            if (!this.modifyResult.isEmpty()) {
                this.json.addProperty("kubejs:modify_result", this.modifyResult);
            }
            if (this.recipeIngredientActions != null && !this.recipeIngredientActions.isEmpty()) {
                try {
                    this.json.add("kubejs:ingredient_actions", (JsonElement)IngredientActionHolder.LIST_CODEC.encodeStart(this.type.event.registries.json(), this.recipeIngredientActions).getOrThrow());
                }
                catch (Exception ex) {
                    ConsoleJS.SERVER.error("Failed to encode kubejs:ingredient_actions", ex, RecipesKubeEvent.CREATE_RECIPE_SKIP_ERROR);
                }
            }
            if (this.newRecipe) {
                this.json.addProperty("type", this.getSerializationTypeFunction().idString);
            }
            ResourceLocation id = this.getOrCreateId();
            if (this.type.event.stageSerializer != null && this.json.has("kubejs:stage") && !this.type.idString.equals("recipestages:stage")) {
                JsonObject o = new JsonObject();
                o.addProperty("stage", this.json.get("kubejs:stage").getAsString());
                o.add("recipe", (JsonElement)this.json);
                Recipe recipe = (Recipe)this.type.event.registries.decodeJson(this.type.event.stageSerializer.codec(), (JsonElement)o);
                return new RecipeHolder(id, recipe);
            }
        } else if (this.originalRecipe != null) {
            return new RecipeHolder(this.getOrCreateId(), (Recipe)this.originalRecipe.getValue());
        }
        return RecipeHelper.fromJson(this.type.event.registries.json(), this.getSerializationTypeFunction().schemaType.getSerializer(), this.getOrCreateId(), this.json, !FMLLoader.isProduction());
    }

    @Nullable
    public Recipe<?> getOriginalRecipe() {
        if (this.originalRecipe == null) {
            this.originalRecipe = new MutableObject();
            try {
                this.originalRecipe.setValue((Object)RecipeHelper.fromJson(this.type.event.registries.json(), this.type.schemaType.getSerializer(), this.getOrCreateId(), this.json, !FMLLoader.isProduction()).value());
            }
            catch (Throwable e) {
                ConsoleJS.SERVER.error("Could not create recipe from json for " + String.valueOf(this), e);
            }
        }
        return (Recipe)this.originalRecipe.getValue();
    }

    public ItemStack getOriginalRecipeResult() {
        if (this.getOriginalRecipe() == null) {
            ConsoleJS.SERVER.warn("Original recipe is null - could not get result");
            return ItemStack.EMPTY;
        }
        ItemStack result = this.getOriginalRecipe().getResultItem((HolderLookup.Provider)this.type.event.registries.access());
        return result == null ? ItemStack.EMPTY : result;
    }

    public List<Ingredient> getOriginalRecipeIngredients() {
        if (this.getOriginalRecipe() == null) {
            ConsoleJS.SERVER.warn("Original recipe is null - could not get ingredients");
            return List.of();
        }
        return List.copyOf(this.getOriginalRecipe().getIngredients());
    }

    public KubeRecipe ingredientAction(SlotFilter filter, IngredientAction action) {
        if (this.recipeIngredientActions == null) {
            this.recipeIngredientActions = new ArrayList<IngredientActionHolder>(2);
        }
        this.recipeIngredientActions.add(new IngredientActionHolder(action, filter));
        this.save();
        return this;
    }

    public final KubeRecipe damageIngredient(SlotFilter filter, int damage) {
        return this.ingredientAction(filter, new DamageAction(damage));
    }

    public final KubeRecipe damageIngredient(SlotFilter filter) {
        return this.damageIngredient(filter, 1);
    }

    public final KubeRecipe replaceIngredient(SlotFilter filter, ItemStack item) {
        return this.ingredientAction(filter, new ReplaceAction(item));
    }

    public final KubeRecipe customIngredientAction(SlotFilter filter, String id) {
        return this.ingredientAction(filter, new CustomIngredientAction(id));
    }

    public final KubeRecipe keepIngredient(SlotFilter filter) {
        return this.ingredientAction(filter, new KeepAction());
    }

    public final KubeRecipe consumeIngredient(SlotFilter filter) {
        return this.ingredientAction(filter, new ConsumeAction());
    }

    public final KubeRecipe modifyResult(String id) {
        this.modifyResult = id;
        this.save();
        return this;
    }
}

