/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.player;

import dev.latvian.mods.kubejs.CommonProperties;
import dev.latvian.mods.kubejs.bindings.event.PlayerEvents;
import dev.latvian.mods.kubejs.net.SyncRecipeViewerDataPayload;
import dev.latvian.mods.kubejs.player.ChestKubeEvent;
import dev.latvian.mods.kubejs.player.InventoryKubeEvent;
import dev.latvian.mods.kubejs.player.PlayerAdvancementKubeEvent;
import dev.latvian.mods.kubejs.player.PlayerChatReceivedKubeEvent;
import dev.latvian.mods.kubejs.player.PlayerClonedKubeEvent;
import dev.latvian.mods.kubejs.player.PlayerRespawnedKubeEvent;
import dev.latvian.mods.kubejs.player.SimplePlayerKubeEvent;
import dev.latvian.mods.kubejs.script.ConsoleJS;
import dev.latvian.mods.kubejs.script.ScriptType;
import dev.latvian.mods.kubejs.script.ScriptTypeHolder;
import java.util.Optional;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.inventory.InventoryMenu;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.ICancellableEvent;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.OnDatapackSyncEvent;
import net.neoforged.neoforge.event.ServerChatEvent;
import net.neoforged.neoforge.event.entity.player.AdvancementEvent;
import net.neoforged.neoforge.event.entity.player.PlayerContainerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import net.neoforged.neoforge.network.PacketDistributor;

@EventBusSubscriber(modid="kubejs")
public class KubeJSPlayerEventHandler {
    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void datapackSync(OnDatapackSyncEvent event) {
        SyncRecipeViewerDataPayload payload = new SyncRecipeViewerDataPayload(Optional.ofNullable(event.getPlayerList().getServer().getServerResources().managers().kjs$getServerScriptManager().recipeViewerData));
        event.getRelevantPlayers().forEach(player -> PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)payload, (CustomPacketPayload[])new CustomPacketPayload[0]));
    }

    @SubscribeEvent
    public static void loggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            if (PlayerEvents.LOGGED_IN.hasListeners()) {
                PlayerEvents.LOGGED_IN.post(ScriptType.SERVER, new SimplePlayerKubeEvent((Player)player2));
            }
            player2.inventoryMenu.addSlotListener((ContainerListener)player2.kjs$getInventoryChangeListener());
            if (!ConsoleJS.SERVER.errors.isEmpty() && !CommonProperties.get().hideServerScriptErrors) {
                player2.displayClientMessage(ConsoleJS.SERVER.errorsComponent("/kubejs errors server"), false);
            }
            player2.kjs$getStages().sync();
        }
    }

    @SubscribeEvent
    public static void cloned(PlayerEvent.Clone event) {
        Player player = event.getOriginal();
        if (player instanceof ServerPlayer) {
            ServerPlayer oldPlayer = (ServerPlayer)player;
            player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer newPlayer = (ServerPlayer)player;
                newPlayer.kjs$setRawPersistentData(oldPlayer.kjs$getRawPersistentData());
                newPlayer.inventoryMenu.addSlotListener((ContainerListener)newPlayer.kjs$getInventoryChangeListener());
                if (PlayerEvents.CLONED.hasListeners()) {
                    PlayerEvents.CLONED.post(ScriptType.SERVER, new PlayerClonedKubeEvent(newPlayer, oldPlayer, !event.isWasDeath()));
                }
            }
        }
    }

    @SubscribeEvent
    public static void respawn(PlayerEvent.PlayerRespawnEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            if (PlayerEvents.RESPAWNED.hasListeners()) {
                PlayerEvents.RESPAWNED.post(ScriptType.SERVER, new PlayerRespawnedKubeEvent(player2, event.isEndConquered()));
            }
            player2.kjs$getStages().sync();
        }
    }

    @SubscribeEvent
    public static void loggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        Player player;
        if (PlayerEvents.LOGGED_OUT.hasListeners() && (player = event.getEntity()) instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            PlayerEvents.LOGGED_OUT.post(ScriptType.SERVER, new SimplePlayerKubeEvent((Player)player2));
        }
    }

    @SubscribeEvent
    public static void tick(PlayerTickEvent.Post event) {
        Player player;
        if (PlayerEvents.TICK.hasListeners() && (player = event.getEntity()) instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            PlayerEvents.TICK.post((ScriptTypeHolder)player2, new SimplePlayerKubeEvent((Player)player2));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void chatDecorate(ServerChatEvent event) {
        if (PlayerEvents.DECORATE_CHAT.hasListeners()) {
            PlayerEvents.DECORATE_CHAT.post(ScriptType.SERVER, new PlayerChatReceivedKubeEvent(event)).applyCancel((ICancellableEvent)event);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void chatReceived(ServerChatEvent event) {
        if (PlayerEvents.CHAT.hasListeners()) {
            PlayerEvents.CHAT.post(ScriptType.SERVER, new PlayerChatReceivedKubeEvent(event)).applyCancel((ICancellableEvent)event);
        }
    }

    @SubscribeEvent
    public static void advancement(AdvancementEvent.AdvancementEarnEvent event) {
        Player player;
        ResourceLocation id = event.getAdvancement().id();
        if (PlayerEvents.ADVANCEMENT.hasListeners(id) && (player = event.getEntity()) instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            PlayerEvents.ADVANCEMENT.post(new PlayerAdvancementKubeEvent(player2, player2.server.kjs$getAdvancement(id)), id);
        }
    }

    @SubscribeEvent
    public static void inventoryOpened(PlayerContainerEvent.Open event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ResourceKey key;
            ServerPlayer player2 = (ServerPlayer)player;
            AbstractContainerMenu menu = event.getContainer();
            if (!(menu instanceof InventoryMenu)) {
                menu.addSlotListener((ContainerListener)player2.kjs$getInventoryChangeListener());
            }
            try {
                key = menu.getType().kjs$getRegistryKey();
            }
            catch (Exception ex) {
                return;
            }
            if (key != null) {
                if (PlayerEvents.INVENTORY_OPENED.hasListeners(key)) {
                    PlayerEvents.INVENTORY_OPENED.post((ScriptTypeHolder)player2, key, new InventoryKubeEvent((Player)player2, menu));
                }
                if (menu instanceof ChestMenu && PlayerEvents.CHEST_OPENED.hasListeners(key)) {
                    PlayerEvents.CHEST_OPENED.post((ScriptTypeHolder)player2, key, new ChestKubeEvent((Player)player2, menu));
                }
            }
        }
    }

    @SubscribeEvent
    public static void inventoryClosed(PlayerContainerEvent.Close event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ResourceKey key;
            ServerPlayer player2 = (ServerPlayer)player;
            AbstractContainerMenu menu = event.getContainer();
            try {
                key = menu.getType().kjs$getRegistryKey();
            }
            catch (Exception ex) {
                return;
            }
            if (key != null) {
                if (PlayerEvents.INVENTORY_CLOSED.hasListeners(key)) {
                    PlayerEvents.INVENTORY_CLOSED.post((ScriptTypeHolder)player2, key, new InventoryKubeEvent((Player)player2, menu));
                }
                if (menu instanceof ChestMenu && PlayerEvents.CHEST_CLOSED.hasListeners(key)) {
                    PlayerEvents.CHEST_CLOSED.post((ScriptTypeHolder)player2, key, new ChestKubeEvent((Player)player2, menu));
                }
            }
        }
    }
}

