/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.neoforge;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import dev.latvian.mods.kubejs.KubeJS;
import dev.latvian.mods.kubejs.bindings.event.ClientEvents;
import dev.latvian.mods.kubejs.bindings.event.ItemEvents;
import dev.latvian.mods.kubejs.block.BlockBuilder;
import dev.latvian.mods.kubejs.block.BlockRenderType;
import dev.latvian.mods.kubejs.client.BlockEntityRendererRegistryKubeEvent;
import dev.latvian.mods.kubejs.client.BlockTintFunctionWrapper;
import dev.latvian.mods.kubejs.client.EntityRendererRegistryKubeEvent;
import dev.latvian.mods.kubejs.client.ItemTintFunctionWrapper;
import dev.latvian.mods.kubejs.client.KubeJSClient;
import dev.latvian.mods.kubejs.client.KubeJSResourcePackFinder;
import dev.latvian.mods.kubejs.client.MenuScreenRegistryKubeEvent;
import dev.latvian.mods.kubejs.fluid.FluidBlockBuilder;
import dev.latvian.mods.kubejs.fluid.FluidBucketItemBuilder;
import dev.latvian.mods.kubejs.fluid.FluidBuilder;
import dev.latvian.mods.kubejs.gui.KubeJSMenus;
import dev.latvian.mods.kubejs.gui.KubeJSScreen;
import dev.latvian.mods.kubejs.item.ItemBuilder;
import dev.latvian.mods.kubejs.item.ItemModelPropertiesKubeEvent;
import dev.latvian.mods.kubejs.kubedex.KubedexHighlight;
import dev.latvian.mods.kubejs.registry.BuilderBase;
import dev.latvian.mods.kubejs.registry.RegistryInfo;
import dev.latvian.mods.kubejs.script.ScriptType;
import dev.latvian.mods.kubejs.util.ID;
import java.io.IOException;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.RepositorySource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.client.event.RegisterShadersEvent;
import net.neoforged.neoforge.client.settings.IKeyConflictContext;
import net.neoforged.neoforge.client.settings.KeyConflictContext;
import net.neoforged.neoforge.client.settings.KeyModifier;
import net.neoforged.neoforge.event.AddPackFindersEvent;

@EventBusSubscriber(modid="kubejs", value={Dist.CLIENT}, bus=EventBusSubscriber.Bus.MOD)
public class KubeJSNeoForgeClient {
    @SubscribeEvent(priority=EventPriority.LOW)
    public static void setupClient(FMLClientSetupEvent event) {
        KubeJS.PROXY = new KubeJSClient();
        event.enqueueWork(KubeJSNeoForgeClient::setupClient0);
    }

    @SubscribeEvent
    public static void addClientPacks(AddPackFindersEvent event) {
        if (event.getPackType() == PackType.CLIENT_RESOURCES) {
            event.addRepositorySource((RepositorySource)new KubeJSResourcePackFinder());
        }
    }

    private static void setupClient0() {
        BuilderBase b;
        ItemEvents.MODEL_PROPERTIES.post(ScriptType.STARTUP, new ItemModelPropertiesKubeEvent());
        for (BuilderBase<Block> builderBase : RegistryInfo.BLOCK) {
            BlockRenderType blockRenderType;
            if (!(builderBase instanceof BlockBuilder)) continue;
            b = (BlockBuilder)builderBase;
            if (b instanceof FluidBlockBuilder) {
                FluidBlockBuilder fb = (FluidBlockBuilder)b;
                blockRenderType = fb.fluidBuilder.fluidType.renderType;
            } else {
                blockRenderType = ((BlockBuilder)b).renderType;
            }
            switch (blockRenderType) {
                case CUTOUT: {
                    ItemBlockRenderTypes.setRenderLayer((Block)((Block)b.get()), (RenderType)RenderType.cutout());
                    break;
                }
                case CUTOUT_MIPPED: {
                    ItemBlockRenderTypes.setRenderLayer((Block)((Block)b.get()), (RenderType)RenderType.cutoutMipped());
                    break;
                }
                case TRANSLUCENT: {
                    ItemBlockRenderTypes.setRenderLayer((Block)((Block)b.get()), (RenderType)RenderType.translucent());
                }
            }
        }
        for (BuilderBase<Block> builderBase : RegistryInfo.FLUID) {
            if (!(builderBase instanceof FluidBuilder)) continue;
            b = (FluidBuilder)builderBase;
            switch (((FluidBuilder)b).fluidType.renderType) {
                case CUTOUT: {
                    ItemBlockRenderTypes.setRenderLayer((Fluid)((FlowingFluid)b.get()).getSource(), (RenderType)RenderType.cutout());
                    ItemBlockRenderTypes.setRenderLayer((Fluid)((FlowingFluid)b.get()).getFlowing(), (RenderType)RenderType.cutout());
                    break;
                }
                case CUTOUT_MIPPED: {
                    ItemBlockRenderTypes.setRenderLayer((Fluid)((FlowingFluid)b.get()).getSource(), (RenderType)RenderType.cutoutMipped());
                    ItemBlockRenderTypes.setRenderLayer((Fluid)((FlowingFluid)b.get()).getFlowing(), (RenderType)RenderType.cutoutMipped());
                    break;
                }
                case TRANSLUCENT: {
                    ItemBlockRenderTypes.setRenderLayer((Fluid)((FlowingFluid)b.get()).getSource(), (RenderType)RenderType.translucent());
                    ItemBlockRenderTypes.setRenderLayer((Fluid)((FlowingFluid)b.get()).getFlowing(), (RenderType)RenderType.translucent());
                }
            }
        }
    }

    @SubscribeEvent
    public static void blockColors(RegisterColorHandlersEvent.Block event) {
        for (BuilderBase<Block> builderBase : RegistryInfo.BLOCK) {
            if (!(builderBase instanceof BlockBuilder)) continue;
            BlockBuilder b = (BlockBuilder)builderBase;
            if (b.tint == null) continue;
            event.register((BlockColor)new BlockTintFunctionWrapper(b.tint), new Block[]{(Block)b.get()});
        }
    }

    @SubscribeEvent
    public static void itemColors(RegisterColorHandlersEvent.Item event) {
        for (BuilderBase<Item> builderBase : RegistryInfo.ITEM) {
            ItemBuilder b;
            if (builderBase instanceof ItemBuilder) {
                b = (ItemBuilder)builderBase;
                if (b.tint != null) {
                    event.register((ItemColor)new ItemTintFunctionWrapper(b.tint), new ItemLike[]{(ItemLike)b.get()});
                }
            }
            if (!(builderBase instanceof FluidBucketItemBuilder)) continue;
            b = (FluidBucketItemBuilder)builderBase;
            if (((FluidBucketItemBuilder)b).fluidBuilder.bucketTint == null && ((FluidBucketItemBuilder)b).fluidBuilder.fluidType.tint == null) continue;
            event.register((arg_0, arg_1) -> KubeJSNeoForgeClient.lambda$itemColors$0((FluidBucketItemBuilder)b, arg_0, arg_1), new ItemLike[]{(ItemLike)b.get()});
        }
    }

    @SubscribeEvent
    public static void registerMenuScreens(RegisterMenuScreensEvent event) {
        event.register(KubeJSMenus.MENU.get(), KubeJSScreen::new);
        ClientEvents.MENU_SCREEN_REGISTRY.post(ScriptType.STARTUP, new MenuScreenRegistryKubeEvent(event));
    }

    @SubscribeEvent
    public static void registerRenderers(EntityRenderersEvent.RegisterRenderers event) {
        ClientEvents.ENTITY_RENDERER_REGISTRY.post(ScriptType.STARTUP, new EntityRendererRegistryKubeEvent(event));
        ClientEvents.BLOCK_ENTITY_RENDERER_REGISTRY.post(ScriptType.STARTUP, new BlockEntityRendererRegistryKubeEvent(event));
    }

    @SubscribeEvent
    public static void registerKeyMappings(RegisterKeyMappingsEvent event) {
        KubedexHighlight.keyMapping = new KeyMapping("key.kubejs.kubedex", (IKeyConflictContext)KeyConflictContext.UNIVERSAL, KeyModifier.NONE, InputConstants.Type.KEYSYM, 75, "key.categories.kubejs");
        event.register(KubedexHighlight.keyMapping);
    }

    @SubscribeEvent
    public static void registerCoreShaders(RegisterShadersEvent event) throws IOException {
        event.registerShader(new ShaderInstance(event.getResourceProvider(), ID.mc("kubejs/rendertype_highlight"), DefaultVertexFormat.POSITION_COLOR), s -> {
            KubedexHighlight.INSTANCE.highlightShader = s;
        });
    }

    private static /* synthetic */ int lambda$itemColors$0(FluidBucketItemBuilder b, ItemStack stack, int index) {
        return index == 1 ? (b.fluidBuilder.bucketTint == null ? b.fluidBuilder.fluidType.tint : b.fluidBuilder.bucketTint).getArgbJS() : -1;
    }
}

