/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.misc;

import dev.latvian.mods.kubejs.misc.MobEffectBuilder;
import dev.latvian.mods.kubejs.registry.RegistryInfo;
import dev.latvian.mods.kubejs.script.ScriptType;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import org.jetbrains.annotations.NotNull;

public class BasicMobEffect
extends MobEffect {
    private final MobEffectBuilder.EffectTickCallback effectTickCallback;
    private final Map<ResourceLocation, MobEffect.AttributeTemplate> modifierMap;
    private boolean modified = false;
    private final ResourceLocation id;
    private final boolean instant;

    public BasicMobEffect(Builder builder) {
        super(builder.category, builder.color);
        this.effectTickCallback = builder.effectTick;
        this.modifierMap = builder.attributeModifiers;
        this.id = builder.id;
        this.instant = builder.instant;
    }

    public boolean applyEffectTick(@NotNull LivingEntity livingEntity, int i) {
        try {
            this.effectTickCallback.applyEffectTick(livingEntity, i);
            return true;
        }
        catch (Throwable e) {
            ScriptType.STARTUP.console.error("Error while ticking mob effect " + String.valueOf(this.id) + " for entity " + livingEntity.getName().getString(), e);
            return false;
        }
    }

    private void applyAttributeModifications() {
        if (!this.modified) {
            this.modifierMap.forEach((r, m) -> this.attributeModifiers.put(RegistryInfo.ATTRIBUTE.getHolder((ResourceLocation)r), m));
            this.modified = true;
        }
    }

    public void removeAttributeModifiers(AttributeMap attributeMap) {
        this.applyAttributeModifications();
        super.removeAttributeModifiers(attributeMap);
    }

    public MobEffect addAttributeModifier(Holder<Attribute> attribute, ResourceLocation id, double d, AttributeModifier.Operation operation) {
        this.applyAttributeModifications();
        return super.addAttributeModifier(attribute, id, d, operation);
    }

    public boolean isInstantenous() {
        return this.instant && this.effectTickCallback != null;
    }

    public boolean shouldApplyEffectTickThisTick(int i, int j) {
        return this.effectTickCallback != null;
    }

    public static class Builder
    extends MobEffectBuilder {
        public Builder(ResourceLocation i) {
            super(i);
        }

        @Override
        public MobEffect createObject() {
            return new BasicMobEffect(this);
        }
    }
}

