/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.kubedex;

import com.mojang.serialization.DynamicOps;
import dev.latvian.mods.kubejs.KubeJS;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.NbtOps;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class KubedexPayloadHandler {
    public static void block(ServerPlayer player, BlockPos pos) {
        BlockEntity blockEntity;
        RegistryAccess.Frozen registries = player.server.registryAccess();
        BlockState blockState = player.level().getBlockState(pos);
        if (!blockState.isAir()) {
            KubeJS.LOGGER.info("[Kubedex][" + player.getScoreboardName() + "] Block State " + String.valueOf(blockState) + " @ " + String.valueOf(pos));
        }
        if ((blockEntity = player.level().getBlockEntity(pos)) != null) {
            KubeJS.LOGGER.info("[Kubedex][" + player.getScoreboardName() + "] Block Entity " + String.valueOf(blockEntity.saveWithoutMetadata((HolderLookup.Provider)registries)));
        }
    }

    public static void entity(ServerPlayer player, int entityId) {
        RegistryAccess.Frozen registries = player.server.registryAccess();
        Entity entity = player.level().getEntity(entityId);
        if (entity != null) {
            KubeJS.LOGGER.info("[Kubedex][" + player.getScoreboardName() + "] Entity " + entity.getName().getString() + " #" + entityId + " " + String.valueOf(entity.serializeNBT((HolderLookup.Provider)registries)));
        }
    }

    public static void inventory(ServerPlayer player, List<Integer> slots, List<ItemStack> stacks) {
        LinkedHashSet<ItemStack> allStacks = new LinkedHashSet<ItemStack>(stacks);
        for (int s : slots) {
            ItemStack item;
            if (s < 0 || s >= player.getInventory().getContainerSize() || (item = player.getInventory().getItem(s)).isEmpty()) continue;
            allStacks.add(item);
        }
        KubedexPayloadHandler.itemStacks(player, allStacks);
    }

    public static void itemStacks(ServerPlayer player, Collection<ItemStack> stacks) {
        RegistryOps ops = player.server.registryAccess().createSerializationContext((DynamicOps)NbtOps.INSTANCE);
        for (ItemStack stack : stacks) {
            KubeJS.LOGGER.info("[Kubedex][" + player.getScoreboardName() + "] Item " + stack.kjs$toItemString0((DynamicOps)ops));
        }
    }
}

