/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.item.custom;

import dev.latvian.mods.kubejs.item.ItemBuilder;
import dev.latvian.mods.kubejs.registry.RegistryInfo;
import dev.latvian.mods.rhino.util.ReturnsSelf;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.AnimalArmorItem;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.ArmorMaterials;
import net.minecraft.world.item.Item;

@ReturnsSelf
public class ArmorItemBuilder
extends ItemBuilder {
    public final ArmorItem.Type armorType;
    public Holder<ArmorMaterial> material;

    protected ArmorItemBuilder(ResourceLocation i, ArmorItem.Type t) {
        super(i);
        this.armorType = t;
        this.material = ArmorMaterials.IRON;
        this.unstackable();
    }

    @Override
    public Item createObject() {
        return new ArmorItem(this.material, this.armorType, this.createItemProperties());
    }

    public ArmorItemBuilder material(ResourceLocation id) {
        this.material = RegistryInfo.ARMOR_MATERIAL.getHolder(id);
        return this;
    }

    @ReturnsSelf
    public static class AnimalArmor
    extends ArmorItemBuilder {
        public AnimalArmorItem.BodyType bodyType = AnimalArmorItem.BodyType.CANINE;
        public boolean overlay = true;

        public AnimalArmor(ResourceLocation i) {
            super(i, ArmorItem.Type.BODY);
        }

        @Override
        public Item createObject() {
            return new AnimalArmorItem(this.material, this.bodyType, this.overlay, this.createItemProperties());
        }

        public AnimalArmor bodyType(AnimalArmorItem.BodyType type) {
            this.bodyType = type;
            return this;
        }

        public AnimalArmor overlay(boolean o) {
            this.overlay = o;
            return this;
        }
    }

    public static class Boots
    extends ArmorItemBuilder {
        public Boots(ResourceLocation i) {
            super(i, ArmorItem.Type.BOOTS);
        }
    }

    public static class Leggings
    extends ArmorItemBuilder {
        public Leggings(ResourceLocation i) {
            super(i, ArmorItem.Type.LEGGINGS);
        }
    }

    public static class Chestplate
    extends ArmorItemBuilder {
        public Chestplate(ResourceLocation i) {
            super(i, ArmorItem.Type.CHESTPLATE);
        }
    }

    public static class Helmet
    extends ArmorItemBuilder {
        public Helmet(ResourceLocation i) {
            super(i, ArmorItem.Type.HELMET);
        }
    }
}

