/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.item;

import dev.latvian.mods.kubejs.event.KubeEvent;
import dev.latvian.mods.kubejs.item.ItemPredicate;
import dev.latvian.mods.kubejs.script.ConsoleJS;
import dev.latvian.mods.kubejs.typings.Info;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

@Info(value="Invoked when registering handlers for item tooltips.\n\n`text` can be a component or a list of components.\n")
public class ItemTooltipKubeEvent
implements KubeEvent {
    private final Map<Item, List<StaticTooltipHandler>> map;

    public ItemTooltipKubeEvent(Map<Item, List<StaticTooltipHandler>> m) {
        this.map = m;
    }

    @Info(value="Adds text to all items matching the ingredient.")
    public void add(ItemPredicate item, List<Component> text) {
        if (item.kjs$isWildcard()) {
            this.addToAll(text);
            return;
        }
        StaticTooltipHandlerFromLines l = new StaticTooltipHandlerFromLines(text);
        if (!l.lines.isEmpty()) {
            for (Item i : item.kjs$getItemTypes()) {
                if (i == Items.AIR) continue;
                this.map.computeIfAbsent(i, k -> new ArrayList()).add(l);
            }
        }
    }

    @Info(value="Adds text to all items.")
    public void addToAll(List<Component> text) {
        StaticTooltipHandlerFromLines l = new StaticTooltipHandlerFromLines(text);
        if (!l.lines.isEmpty()) {
            this.map.computeIfAbsent(Items.AIR, k -> new ArrayList()).add(l);
        }
    }

    @Info(value="Adds a dynamic tooltip handler to all items matching the ingredient.")
    public void addAdvanced(ItemPredicate item, StaticTooltipHandlerFromJS handler) {
        if (item.kjs$isWildcard()) {
            this.addAdvancedToAll(handler);
            return;
        }
        StaticTooltipHandlerFromJSWrapper l = new StaticTooltipHandlerFromJSWrapper(handler);
        for (Item i : item.kjs$getItemTypes()) {
            if (i == Items.AIR) continue;
            this.map.computeIfAbsent(i, k -> new ArrayList()).add(l);
        }
    }

    @Info(value="Adds a dynamic tooltip handler to all items.")
    public void addAdvancedToAll(StaticTooltipHandlerFromJS handler) {
        this.map.computeIfAbsent(Items.AIR, k -> new ArrayList()).add(new StaticTooltipHandlerFromJSWrapper(handler));
    }

    @Info(value="Is shift key pressed.")
    public boolean isShift() {
        return Screen.hasShiftDown();
    }

    @Info(value="Is control key pressed.")
    public boolean isCtrl() {
        return Screen.hasControlDown();
    }

    @Info(value="Is alt key pressed.")
    public boolean isAlt() {
        return Screen.hasAltDown();
    }

    public static class StaticTooltipHandlerFromLines
    implements StaticTooltipHandler {
        public final List<Component> lines;

        public StaticTooltipHandlerFromLines(List<Component> l) {
            this.lines = l;
        }

        @Override
        public void tooltip(ItemStack stack, boolean advanced, List<Component> components) {
            if (!stack.isEmpty()) {
                components.addAll(this.lines);
            }
        }
    }

    @FunctionalInterface
    public static interface StaticTooltipHandlerFromJS {
        public void accept(ItemStack var1, boolean var2, List<Component> var3);
    }

    public static class StaticTooltipHandlerFromJSWrapper
    implements StaticTooltipHandler {
        private final StaticTooltipHandlerFromJS handler;

        public StaticTooltipHandlerFromJSWrapper(StaticTooltipHandlerFromJS h) {
            this.handler = h;
        }

        @Override
        public void tooltip(ItemStack stack, boolean advanced, List<Component> components) {
            if (stack.isEmpty()) {
                return;
            }
            ArrayList<Component> text = new ArrayList<Component>(components);
            try {
                this.handler.accept(stack, advanced, text);
            }
            catch (Exception ex) {
                ConsoleJS.CLIENT.error("Error while gathering tooltip for " + String.valueOf(stack), ex);
            }
            components.clear();
            components.addAll(text);
        }
    }

    @FunctionalInterface
    public static interface StaticTooltipHandler {
        public void tooltip(ItemStack var1, boolean var2, List<Component> var3);
    }
}

