/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.item;

import dev.latvian.mods.kubejs.core.IngredientSupplierKJS;
import dev.latvian.mods.kubejs.item.ItemStackJS;
import dev.latvian.mods.kubejs.item.ItemStackSet;
import dev.latvian.mods.kubejs.item.ingredient.IngredientJS;
import dev.latvian.mods.kubejs.script.KubeJSContext;
import dev.latvian.mods.rhino.BaseFunction;
import dev.latvian.mods.rhino.Context;
import dev.latvian.mods.rhino.ScriptableObject;
import dev.latvian.mods.rhino.type.TypeInfo;
import dev.latvian.mods.rhino.util.RemapPrefixForJS;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;

@RemapPrefixForJS(value="kjs$")
public interface ItemPredicate
extends Predicate<ItemStack>,
IngredientSupplierKJS {
    public static final TypeInfo TYPE_INFO = TypeInfo.of(ItemPredicate.class);
    public static final ItemPredicate NONE = stack -> false;
    public static final ItemPredicate ALL = stack -> true;

    public static ItemPredicate wrap(Context cx, Object from) {
        Ingredient in;
        if (from == null) {
            return NONE;
        }
        if (from instanceof BaseFunction) {
            BaseFunction func = (BaseFunction)from;
            return (ItemPredicate)cx.createInterfaceAdapter(TYPE_INFO, (ScriptableObject)func);
        }
        if (from instanceof CharSequence) {
            CharSequence s = (CharSequence)from;
            if (s.equals("*")) {
                return ALL;
            }
            if (s.isEmpty() || s.equals("-")) {
                return NONE;
            }
        }
        if ((in = IngredientJS.wrap(((KubeJSContext)cx).getRegistries(), from)).isEmpty()) {
            return NONE;
        }
        if (in.kjs$isWildcard()) {
            return ALL;
        }
        return in;
    }

    default public boolean kjs$testItem(Item item) {
        return this.test(item.getDefaultInstance());
    }

    default public ItemStack[] kjs$getStackArray() {
        return (ItemStack[])ItemStackJS.getList().stream().filter(this).toArray(ItemStack[]::new);
    }

    default public ItemStackSet kjs$getStacks() {
        return new ItemStackSet(this.kjs$getStackArray());
    }

    default public ItemStackSet kjs$getDisplayStacks() {
        ItemStackSet set = new ItemStackSet();
        for (ItemStack stack : ItemStackJS.getList()) {
            if (!this.test(stack)) continue;
            set.add(stack);
        }
        return set;
    }

    default public boolean kjs$isWildcard() {
        return this == ALL;
    }

    default public Set<Item> kjs$getItemTypes() {
        ItemStack[] items = this.kjs$getStackArray();
        if (items.length == 1 && !items[0].isEmpty()) {
            return Set.of(items[0].getItem());
        }
        LinkedHashSet<Item> set = new LinkedHashSet<Item>(items.length);
        for (ItemStack stack : items) {
            if (stack.isEmpty()) continue;
            set.add(stack.getItem());
        }
        return set;
    }

    default public Set<String> kjs$getItemIds() {
        ItemStack[] items = this.kjs$getStackArray();
        if (items.length == 1 && !items[0].isEmpty()) {
            return Set.of(items[0].kjs$getId());
        }
        LinkedHashSet<String> ids = new LinkedHashSet<String>(items.length);
        for (ItemStack item : items) {
            if (item.isEmpty()) continue;
            ids.add(item.kjs$getId());
        }
        return ids;
    }

    default public ItemStack kjs$getFirst() {
        for (ItemStack stack : this.kjs$getStackArray()) {
            if (stack.isEmpty()) continue;
            return stack;
        }
        return ItemStack.EMPTY;
    }

    default public boolean kjs$canBeUsedForMatching() {
        return true;
    }

    @Override
    default public Ingredient kjs$asIngredient() {
        return Ingredient.of((ItemStack[])this.kjs$getStackArray());
    }
}

