/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.item;

import dev.latvian.mods.kubejs.event.KubeEvent;
import dev.latvian.mods.kubejs.item.ItemPredicate;
import dev.latvian.mods.kubejs.item.MutableToolTier;
import dev.latvian.mods.kubejs.typings.Info;
import java.util.function.Consumer;
import net.minecraft.Util;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;

@Info(value="Invoked after all items are registered to modify them.\n")
public class ItemModificationKubeEvent
implements KubeEvent {
    @Info(value="Modifies items matching the given ingredient.\n\n**NOTE**: tag ingredients are not supported at this time.\n")
    public void modify(ItemPredicate in, Consumer<ItemModifications> c) {
        for (Item item : in.kjs$getItemTypes()) {
            c.accept(new ItemModifications(item));
        }
    }

    public record ItemModifications(Item item) {
        public void setBurnTime(int i) {
        }

        public <T> void overrideComponent(DataComponentType<T> type, T value) {
            this.item.kjs$overrideComponent(type, value);
        }

        public void setCraftingRemainder(Item item) {
            this.item.kjs$setCraftingRemainder(item);
        }

        public void setMaxStackSize(int size) {
            this.overrideComponent(DataComponents.MAX_STACK_SIZE, size);
        }

        public void setTier(Consumer<MutableToolTier> c) {
            Item item = this.item;
            if (!(item instanceof TieredItem)) {
                throw new IllegalArgumentException("Item is not a tool/tiered item!");
            }
            TieredItem tiered = (TieredItem)item;
            tiered.tier = (Tier)Util.make((Object)new MutableToolTier(tiered.tier), c);
        }

        public void setNameKey(String key) {
            this.item.kjs$setNameKey(key);
        }
    }
}

