/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.item;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.latvian.mods.kubejs.item.ItemStackJS;
import dev.latvian.mods.kubejs.recipe.component.RecipeComponent;
import dev.latvian.mods.kubejs.recipe.component.SimpleRecipeComponent;
import dev.latvian.mods.kubejs.script.KubeJSContext;
import dev.latvian.mods.rhino.Context;
import dev.latvian.mods.rhino.type.RecordTypeInfo;
import dev.latvian.mods.rhino.type.TypeInfo;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.ConstantFloat;
import net.minecraft.util.valueproviders.FloatProvider;
import net.minecraft.world.item.ItemStack;

public record ChancedItem(ItemStack item, FloatProvider chance) {
    public static final RecordTypeInfo TYPE_INFO = (RecordTypeInfo)TypeInfo.of(ChancedItem.class);
    public static final FloatProvider DEFAULT_CHANCE = ConstantFloat.of((float)1.0f);
    public static final MapCodec<ChancedItem> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ItemStack.CODEC.fieldOf("item").forGetter(ChancedItem::item), (App)FloatProvider.CODEC.optionalFieldOf("chance", (Object)DEFAULT_CHANCE).forGetter(ChancedItem::chance)).apply((Applicative)instance, ChancedItem::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, ChancedItem> STREAM_CODEC = StreamCodec.composite((StreamCodec)ItemStack.STREAM_CODEC, ChancedItem::item, (StreamCodec)ByteBufCodecs.fromCodec((Codec)FloatProvider.CODEC), ChancedItem::chance, ChancedItem::new);
    public static final RecipeComponent<ChancedItem> RECIPE_COMPONENT = new SimpleRecipeComponent<ChancedItem>("chanced_item", CODEC.codec(), TypeInfo.of(ChancedItem.class));

    public static ChancedItem wrap(Context cx, Object from) {
        if (from instanceof ItemStack) {
            ItemStack is = (ItemStack)from;
            return new ChancedItem(is, DEFAULT_CHANCE);
        }
        if (from instanceof CharSequence) {
            return new ChancedItem(ItemStackJS.wrap(((KubeJSContext)cx).getRegistries(), from), DEFAULT_CHANCE);
        }
        return (ChancedItem)TYPE_INFO.wrap(cx, from, (TypeInfo)TYPE_INFO);
    }

    public boolean test(RandomSource random) {
        return random.nextFloat() < this.chance.sample(random);
    }

    public ItemStack getItemOrEmpty(RandomSource random) {
        return this.test(random) ? this.item : ItemStack.EMPTY;
    }

    public ChancedItem withChance(FloatProvider chance) {
        return new ChancedItem(this.item, chance);
    }
}

