/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.ingredient;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.latvian.mods.kubejs.ingredient.KubeJSIngredient;
import dev.latvian.mods.kubejs.ingredient.KubeJSIngredients;
import dev.latvian.mods.kubejs.recipe.CachedTagLookup;
import dev.latvian.mods.kubejs.recipe.RecipeExceptionJS;
import dev.latvian.mods.kubejs.recipe.RecipesKubeEvent;
import io.netty.buffer.ByteBuf;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.crafting.IngredientType;
import org.jetbrains.annotations.Nullable;

public final class TagIngredient
implements KubeJSIngredient {
    public static final MapCodec<TagIngredient> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)TagKey.codec((ResourceKey)Registries.ITEM).fieldOf("tag").forGetter(t -> t.tagKey)).apply((Applicative)instance, tagKey -> new TagIngredient(null, (TagKey<Item>)tagKey)));
    public static final StreamCodec<ByteBuf, TagIngredient> STREAM_CODEC = ResourceLocation.STREAM_CODEC.map(id -> new TagIngredient(null, (TagKey<Item>)ItemTags.create((ResourceLocation)id)), in -> in.tagKey.location());
    @Nullable
    public final CachedTagLookup<Item> lookup;
    public final TagKey<Item> tagKey;
    private Set<Item> cachedItems;

    public TagIngredient(@Nullable CachedTagLookup<Item> lookup, TagKey<Item> tagKey) {
        this.lookup = lookup;
        this.tagKey = tagKey;
    }

    public IngredientType<?> getType() {
        return KubeJSIngredients.TAG.get();
    }

    public Set<Item> kjs$getItems() {
        if (this.cachedItems == null) {
            if (this.lookup != null) {
                this.cachedItems = this.lookup.values(this.tagKey);
            } else {
                this.cachedItems = new HashSet<Item>();
                for (Item item : BuiltInRegistries.ITEM) {
                    if (!item.builtInRegistryHolder().is(this.tagKey)) continue;
                    this.cachedItems.add(item);
                }
            }
            this.cachedItems = Set.copyOf(this.cachedItems);
        }
        return this.cachedItems;
    }

    @Override
    public boolean test(@Nullable ItemStack stack) {
        if (this.lookup != null) {
            return stack != null && this.kjs$getItems().contains(stack.getItem());
        }
        return stack != null && stack.is(this.tagKey);
    }

    @Override
    public Stream<ItemStack> getItems() {
        Set<Item> set = this.kjs$getItems();
        if (set.isEmpty()) {
            if (RecipesKubeEvent.TEMP_ITEM_TAG_LOOKUP.getValue() != null) {
                throw new RecipeExceptionJS("Empty tag: " + String.valueOf(this.tagKey.location()));
            }
            ItemStack error = new ItemStack((ItemLike)Items.BARRIER);
            error.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)("Empty Tag: " + String.valueOf(this.tagKey.location()))));
            return Stream.of(error);
        }
        return set.stream().map(ItemStack::new);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (obj == this) return true;
        if (!(obj instanceof TagIngredient)) return false;
        TagIngredient i = (TagIngredient)obj;
        if (this.tagKey != i.tagKey) return false;
        return true;
    }

    public int hashCode() {
        return this.tagKey.hashCode();
    }

    public String toString() {
        return "KubeJSItemTagIngredient[" + String.valueOf(this.tagKey.location()) + "]";
    }
}

