/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.ingredient;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.latvian.mods.kubejs.ingredient.KubeJSIngredient;
import dev.latvian.mods.kubejs.ingredient.KubeJSIngredients;
import dev.latvian.mods.kubejs.util.RegExpKJS;
import io.netty.buffer.ByteBuf;
import java.util.regex.Pattern;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.crafting.IngredientType;
import org.jetbrains.annotations.Nullable;

public record RegExIngredient(Pattern pattern, String patternString) implements KubeJSIngredient
{
    public static final MapCodec<RegExIngredient> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)RegExpKJS.CODEC.fieldOf("pattern").forGetter(RegExIngredient::pattern)).apply((Applicative)instance, RegExIngredient::new));
    public static final StreamCodec<ByteBuf, RegExIngredient> STREAM_CODEC = RegExpKJS.STREAM_CODEC.map(RegExIngredient::new, RegExIngredient::pattern);

    public RegExIngredient(Pattern pattern) {
        this(pattern, RegExpKJS.toRegExpString(pattern));
    }

    public IngredientType<?> getType() {
        return KubeJSIngredients.REGEX.get();
    }

    @Override
    public boolean test(@Nullable ItemStack stack) {
        return stack != null && this.pattern.matcher(stack.kjs$getId()).find();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object o) {
        if (o == this) return true;
        if (!(o instanceof RegExIngredient)) return false;
        RegExIngredient i = (RegExIngredient)o;
        if (!this.patternString.equals(i.patternString)) return false;
        return true;
    }

    @Override
    public int hashCode() {
        return this.patternString.hashCode();
    }

    @Override
    public String toString() {
        return "KubeJSItemRegExIngredient[" + this.patternString + "]";
    }
}

