/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.holder;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.latvian.mods.kubejs.holder.KubeJSHolderSets;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.neoforged.neoforge.registries.holdersets.HolderSetType;
import net.neoforged.neoforge.registries.holdersets.ICustomHolderSet;
import org.jetbrains.annotations.Nullable;

public class NamespaceHolderSet<T>
extends HolderSet.ListBacked<T>
implements ICustomHolderSet<T> {
    public final HolderLookup.RegistryLookup<T> registryLookup;
    public final String namespace;
    @Nullable
    private Set<Holder<T>> set = null;
    @Nullable
    private List<Holder<T>> list = null;

    public static <T> MapCodec<NamespaceHolderSet<T>> codec(ResourceKey<? extends Registry<T>> registryKey, Codec<Holder<T>> holderCodec, boolean forceList) {
        return RecordCodecBuilder.mapCodec(instance -> instance.group((App)RegistryOps.retrieveRegistryLookup((ResourceKey)registryKey).fieldOf("registry").forGetter(s -> s.registryLookup), (App)Codec.STRING.fieldOf("namespace").forGetter(s -> s.namespace)).apply((Applicative)instance, NamespaceHolderSet::new));
    }

    public NamespaceHolderSet(HolderLookup.RegistryLookup<T> registryLookup, String namespace) {
        this.registryLookup = registryLookup;
        this.namespace = namespace;
    }

    public HolderSetType type() {
        return (HolderSetType)KubeJSHolderSets.NAMESPACE.value();
    }

    protected List<Holder<T>> contents() {
        if (this.list == null) {
            this.list = List.copyOf(this.registryLookup.listElements().filter(ref -> ref.key().location().getNamespace().equals(this.namespace)).toList());
        }
        return this.list;
    }

    public Either<TagKey<T>, List<Holder<T>>> unwrap() {
        return Either.right(this.contents());
    }

    public boolean contains(Holder<T> holder) {
        if (this.set == null) {
            this.set = Set.copyOf(this.contents());
        }
        return this.set.contains(holder);
    }

    public Optional<TagKey<T>> unwrapKey() {
        return Optional.empty();
    }

    public String toString() {
        return "KubeJSNamespaceHolderSet[" + this.namespace + "]";
    }
}

