/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.holder;

import dev.latvian.mods.kubejs.holder.NamespaceHolderSet;
import dev.latvian.mods.kubejs.holder.RegExHolderSet;
import dev.latvian.mods.kubejs.script.KubeJSContext;
import dev.latvian.mods.kubejs.util.ID;
import dev.latvian.mods.kubejs.util.RegExpKJS;
import dev.latvian.mods.rhino.Context;
import dev.latvian.mods.rhino.type.TypeInfo;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;

public interface HolderWrapper {
    public static final TypeInfo HOLDER = TypeInfo.of(Holder.class);
    public static final TypeInfo HOLDER_SET = TypeInfo.of(HolderSet.class);

    public static Holder<?> wrap(KubeJSContext cx, Object from, TypeInfo param) {
        ResourceLocation id;
        if (from instanceof Holder) {
            Holder h = (Holder)from;
            return h;
        }
        Registry<?> registry = cx.lookupRegistry(param, from);
        Optional holder = registry.getHolder(id = ID.mc(from));
        if (holder.isEmpty()) {
            throw Context.reportRuntimeError((String)("Can't interpret '" + String.valueOf(from) + "' as Holder: entry not found"), (Context)cx);
        }
        return (Holder)holder.get();
    }

    public static HolderSet<?> wrapSet(KubeJSContext cx, Object from, TypeInfo param) {
        Object holder;
        if (from instanceof HolderSet) {
            HolderSet h = (HolderSet)from;
            return h;
        }
        Registry<?> registry = cx.lookupRegistry(param, from);
        Pattern regex = RegExpKJS.wrap(from);
        if (regex != null) {
            return new RegExHolderSet(registry.asLookup(), regex);
        }
        if (from instanceof CharSequence) {
            String s = from.toString();
            if (s.isEmpty()) {
                return HolderSet.empty();
            }
            if (s.charAt(0) == '@') {
                return new NamespaceHolderSet(registry.asLookup(), s.substring(1));
            }
            if (s.charAt(0) == '#') {
                TagKey tagKey = TagKey.create((ResourceKey)registry.key(), (ResourceLocation)ResourceLocation.parse((String)s.substring(1)));
                return registry.getOrCreateTag(tagKey);
            }
        }
        if (from instanceof Iterable) {
            holder = (List)cx.jsToJava(from, TypeInfo.RAW_LIST.withParams(new TypeInfo[]{HOLDER.withParams(new TypeInfo[]{param})}));
            return HolderSet.direct(holder);
        }
        holder = HolderWrapper.wrap(cx, from, param);
        return HolderSet.direct((Holder[])new Holder[]{holder});
    }
}

