/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.generator;

import com.google.gson.JsonElement;
import dev.latvian.mods.kubejs.client.LoadedTexture;
import dev.latvian.mods.kubejs.client.ModelGenerator;
import dev.latvian.mods.kubejs.client.MultipartBlockStateGenerator;
import dev.latvian.mods.kubejs.client.VariantBlockStateGenerator;
import dev.latvian.mods.kubejs.color.Color;
import dev.latvian.mods.kubejs.generator.KubeResourceGenerator;
import dev.latvian.mods.kubejs.script.ConsoleJS;
import dev.latvian.mods.kubejs.script.data.GeneratedData;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.Util;
import net.minecraft.resources.ResourceLocation;

public interface KubeAssetGenerator
extends KubeResourceGenerator {
    public static ResourceLocation asItemModelLocation(ResourceLocation id) {
        return ResourceLocation.fromNamespaceAndPath((String)id.getNamespace(), (String)("models/item/" + id.getPath()));
    }

    default public void addLang(String key, String value) {
        ConsoleJS.CLIENT.error("Use ClientEvents.lang('en_us', event => { event.add(key, value) }) instead!");
    }

    default public LoadedTexture loadTexture(ResourceLocation id) {
        return LoadedTexture.load(id);
    }

    default public void blockState(ResourceLocation id, Consumer<VariantBlockStateGenerator> consumer) {
        VariantBlockStateGenerator gen = (VariantBlockStateGenerator)Util.make((Object)new VariantBlockStateGenerator(), consumer);
        this.json(ResourceLocation.fromNamespaceAndPath((String)id.getNamespace(), (String)("blockstates/" + id.getPath())), (JsonElement)gen.toJson());
    }

    default public void multipartState(ResourceLocation id, Consumer<MultipartBlockStateGenerator> consumer) {
        MultipartBlockStateGenerator gen = (MultipartBlockStateGenerator)Util.make((Object)new MultipartBlockStateGenerator(), consumer);
        this.json(ResourceLocation.fromNamespaceAndPath((String)id.getNamespace(), (String)("blockstates/" + id.getPath())), (JsonElement)gen.toJson());
    }

    default public void blockModel(ResourceLocation id, Consumer<ModelGenerator> consumer) {
        ModelGenerator gen = (ModelGenerator)Util.make((Object)new ModelGenerator(), consumer);
        this.json(ResourceLocation.fromNamespaceAndPath((String)id.getNamespace(), (String)("models/block/" + id.getPath())), (JsonElement)gen.toJson());
    }

    default public void itemModel(ResourceLocation id, Consumer<ModelGenerator> consumer) {
        ModelGenerator gen = (ModelGenerator)Util.make((Object)new ModelGenerator(), consumer);
        this.json(KubeAssetGenerator.asItemModelLocation(id), (JsonElement)gen.toJson());
    }

    default public void defaultItemModel(ResourceLocation id) {
        this.itemModel(id, model -> {
            model.parent("minecraft:item/generated");
            model.texture("layer0", id.getNamespace() + ":item/" + id.getPath());
        });
    }

    default public void defaultHandheldItemModel(ResourceLocation id) {
        this.itemModel(id, model -> {
            model.parent("minecraft:item/handheld");
            model.texture("layer0", id.getNamespace() + ":item/" + id.getPath());
        });
    }

    default public void texture(ResourceLocation target, LoadedTexture texture) {
        if (texture.width <= 0 || texture.height <= 0) {
            ConsoleJS.CLIENT.error("Failed to save texture " + String.valueOf(target));
            return;
        }
        this.add(new GeneratedData(ResourceLocation.fromNamespaceAndPath((String)target.getNamespace(), (String)("textures/" + target.getPath() + ".png")), texture::toBytes));
        if (texture.mcmeta != null) {
            this.add(new GeneratedData(ResourceLocation.fromNamespaceAndPath((String)target.getNamespace(), (String)("textures/" + target.getPath() + ".png.mcmeta")), () -> texture.mcmeta));
        }
    }

    default public void stencil(ResourceLocation target, ResourceLocation stencil, Map<Color, Color> colors) {
        LoadedTexture stencilTexture = this.loadTexture(stencil);
        if (stencilTexture.width == 0 || stencilTexture.height == 0) {
            ConsoleJS.CLIENT.error("Failed to load texture " + String.valueOf(stencil));
            return;
        }
        this.texture(target, stencilTexture.remap(colors));
    }

    default public boolean mask(ResourceLocation target, ResourceLocation mask, ResourceLocation input) {
        LoadedTexture maskTexture = this.loadTexture(mask);
        if (maskTexture.height != maskTexture.width || maskTexture.width == 0) {
            return false;
        }
        LoadedTexture in = this.loadTexture(input);
        if (in.width == 0 || in.height == 0) {
            return false;
        }
        int w = Math.max(maskTexture.width, in.width);
        if (maskTexture.width != in.width) {
            int mframes = maskTexture.height / maskTexture.width;
            int iframes = in.height / in.width;
            maskTexture = maskTexture.resize(w, w * mframes);
            in = in.resize(w, w * iframes).copy();
        } else {
            in = in.copy();
        }
        for (int y = 0; y < in.height; ++y) {
            for (int x = 0; x < w; ++x) {
                int ii = x + y * w;
                int m = maskTexture.pixels[x + y % maskTexture.height * w];
                int ma = m >> 24 & 0xFF;
                if (ma == 0) {
                    in.pixels[ii] = 0;
                    continue;
                }
                float mr = (float)(m >> 16 & 0xFF) / 255.0f;
                float mg = (float)(m >> 8 & 0xFF) / 255.0f;
                float mb = (float)(m & 0xFF) / 255.0f;
                float ir = (float)(in.pixels[ii] >> 16 & 0xFF) / 255.0f;
                float ig = (float)(in.pixels[ii] >> 8 & 0xFF) / 255.0f;
                float ib = (float)(in.pixels[ii] & 0xFF) / 255.0f;
                in.pixels[ii] = (int)(mr * ir * 255.0f) << 16 | (int)(mg * ig * 255.0f) << 8 | (int)(mb * ib * 255.0f) | ma << 24;
            }
        }
        this.texture(target, in);
        return true;
    }
}

