/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.fluid;

import dev.latvian.mods.kubejs.block.BlockRenderType;
import dev.latvian.mods.kubejs.color.Color;
import dev.latvian.mods.kubejs.color.SimpleColor;
import dev.latvian.mods.kubejs.fluid.FlowingFluidBuilder;
import dev.latvian.mods.kubejs.fluid.FluidBlockBuilder;
import dev.latvian.mods.kubejs.fluid.FluidBucketItemBuilder;
import dev.latvian.mods.kubejs.fluid.FluidTypeBuilder;
import dev.latvian.mods.kubejs.registry.AdditionalObjectRegistry;
import dev.latvian.mods.kubejs.registry.BuilderBase;
import dev.latvian.mods.kubejs.registry.RegistryInfo;
import dev.latvian.mods.rhino.util.ReturnsSelf;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.material.FlowingFluid;
import net.neoforged.neoforge.fluids.BaseFlowingFluid;

@ReturnsSelf
public class FluidBuilder
extends BuilderBase<FlowingFluid> {
    public static final Color WATER_COLOR = new SimpleColor(-12618012);
    public transient Color bucketTint = null;
    public transient int slopeFindDistance = 4;
    public transient int levelDecreasePerBlock = 1;
    public transient float explosionResistance = 1.0f;
    public transient int tickRate = 5;
    public FluidTypeBuilder fluidType = new FluidTypeBuilder(this.id);
    public FlowingFluidBuilder flowingFluid = new FlowingFluidBuilder(this);
    public FluidBlockBuilder block = new FluidBlockBuilder(this);
    public FluidBucketItemBuilder bucketItem = new FluidBucketItemBuilder(this);
    private BaseFlowingFluid.Properties properties;

    public FluidBuilder(ResourceLocation i) {
        super(i);
    }

    @Override
    public BuilderBase<FlowingFluid> displayName(Component name) {
        if (this.block != null) {
            this.block.displayName(name);
        }
        if (this.bucketItem != null) {
            this.bucketItem.displayName((Component)Component.literal((String)"").append(name).append(" Bucket"));
        }
        return super.displayName(name);
    }

    @Override
    public final RegistryInfo getRegistryType() {
        return RegistryInfo.FLUID;
    }

    public BaseFlowingFluid.Properties createProperties() {
        if (this.properties == null) {
            this.properties = new BaseFlowingFluid.Properties((Supplier)this.fluidType, (Supplier)this, (Supplier)this.flowingFluid);
            this.properties.bucket((Supplier)this.bucketItem);
            this.properties.block((Supplier)this.block);
            this.properties.slopeFindDistance(this.slopeFindDistance);
            this.properties.levelDecreasePerBlock(this.levelDecreasePerBlock);
            this.properties.explosionResistance(this.explosionResistance);
            this.properties.tickRate(this.tickRate);
        }
        return this.properties;
    }

    @Override
    public FlowingFluid createObject() {
        return new BaseFlowingFluid.Source(this.createProperties());
    }

    @Override
    public void createAdditionalObjects(AdditionalObjectRegistry registry) {
        registry.add(RegistryInfo.FLUID_TYPE, this.fluidType);
        registry.add(RegistryInfo.FLUID, this.flowingFluid);
        if (this.block != null) {
            registry.add(RegistryInfo.BLOCK, this.block);
        }
        if (this.bucketItem != null) {
            registry.add(RegistryInfo.ITEM, this.bucketItem);
        }
    }

    @Override
    public BuilderBase<FlowingFluid> tag(ResourceLocation[] tag) {
        this.flowingFluid.tag(tag);
        return super.tag(tag);
    }

    public FluidBuilder type(Consumer<FluidTypeBuilder> builder) {
        builder.accept(this.fluidType);
        return this;
    }

    public FluidBuilder tint(Color c) {
        this.fluidType.tint = c;
        return this;
    }

    public FluidBuilder bucketTint(Color c) {
        this.bucketTint = c;
        return this;
    }

    public FluidBuilder stillTexture(ResourceLocation id) {
        this.fluidType.stillTexture = id;
        return this;
    }

    public FluidBuilder flowingTexture(ResourceLocation id) {
        this.fluidType.flowingTexture = id;
        return this;
    }

    public FluidBuilder renderType(BlockRenderType l) {
        this.fluidType.renderType = l;
        return this;
    }

    public FluidBuilder translucent() {
        return this.renderType(BlockRenderType.TRANSLUCENT);
    }

    public FluidBuilder slopeFindDistance(int slopeFindDistance) {
        this.slopeFindDistance = slopeFindDistance;
        return this;
    }

    public FluidBuilder levelDecreasePerBlock(int levelDecreasePerBlock) {
        this.levelDecreasePerBlock = levelDecreasePerBlock;
        return this;
    }

    public FluidBuilder explosionResistance(float explosionResistance) {
        this.explosionResistance = explosionResistance;
        return this;
    }

    public FluidBuilder tickRate(int tickRate) {
        this.tickRate = tickRate;
        return this;
    }

    public FluidBuilder noBucket() {
        this.bucketItem = null;
        return this;
    }

    public FluidBuilder noBlock() {
        this.block = null;
        return this;
    }
}

