/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.fluid;

import com.google.gson.JsonElement;
import dev.latvian.mods.kubejs.KubeJS;
import dev.latvian.mods.kubejs.fluid.FluidBuilder;
import dev.latvian.mods.kubejs.generator.KubeAssetGenerator;
import dev.latvian.mods.kubejs.item.ItemBuilder;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.level.material.Fluid;

public class FluidBucketItemBuilder
extends ItemBuilder {
    public final FluidBuilder fluidBuilder;

    public FluidBucketItemBuilder(FluidBuilder b) {
        super(b.newID("", "_bucket"));
        this.fluidBuilder = b;
        this.maxStackSize(1);
    }

    @Override
    public BucketItem createObject() {
        return new BucketItem((Fluid)this.fluidBuilder.get(), this.createItemProperties());
    }

    @Override
    public void generateAssetJsons(KubeAssetGenerator generator) {
        if (this.modelJson != null) {
            generator.json(KubeAssetGenerator.asItemModelLocation(this.id), (JsonElement)this.modelJson);
            return;
        }
        boolean maskTexture = this.fluidBuilder.bucketTint == null && generator.mask(this.newID("item/", "_bucket_fluid"), KubeJS.id("item/bucket_mask"), this.fluidBuilder.fluidType.stillTexture);
        generator.itemModel(this.id, m -> {
            if (!this.parentModel.isEmpty()) {
                m.parent(this.parentModel);
            } else {
                m.parent("kubejs:item/generated_bucket");
            }
            if (maskTexture) {
                m.texture("bucket_fluid", this.newID("item/", "_bucket_fluid"));
            } else {
                m.texture("bucket_fluid", "kubejs:item/bucket_fluid");
            }
            if (!this.textureJson.isEmpty()) {
                m.textures(this.textureJson);
            }
        });
    }
}

