/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.fluid;

import dev.latvian.mods.kubejs.block.BlockBuilder;
import dev.latvian.mods.kubejs.block.BlockRenderType;
import dev.latvian.mods.kubejs.fluid.FluidBuilder;
import dev.latvian.mods.kubejs.generator.KubeAssetGenerator;
import dev.latvian.mods.kubejs.item.ItemBuilder;
import java.util.function.Consumer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.FlowingFluid;
import org.jetbrains.annotations.Nullable;

public class FluidBlockBuilder
extends BlockBuilder {
    public final FluidBuilder fluidBuilder;

    public FluidBlockBuilder(FluidBuilder b) {
        super(b.id);
        this.fluidBuilder = b;
        this.defaultTranslucent();
        this.noItem();
        this.noDrops();
        this.renderType(BlockRenderType.SOLID);
    }

    @Override
    public Block createObject() {
        return new LiquidBlock((FlowingFluid)this.fluidBuilder.get(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.WATER).noCollission().strength(100.0f).noLootTable());
    }

    @Override
    public void generateAssetJsons(KubeAssetGenerator generator) {
        generator.blockState(this.id, m -> m.simpleVariant("", this.id.getNamespace() + ":block/" + this.id.getPath()));
        generator.blockModel(this.id, m -> {
            m.parent("");
            m.texture("particle", this.fluidBuilder.fluidType.stillTexture.toString());
        });
    }

    @Override
    public BlockBuilder item(@Nullable Consumer<ItemBuilder> i) {
        if (i != null) {
            throw new IllegalStateException("Fluid blocks cannot have items!");
        }
        return super.item(null);
    }
}

