/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.event;

import dev.latvian.mods.kubejs.core.RegistryObjectKJS;
import dev.latvian.mods.kubejs.util.Cast;
import dev.latvian.mods.kubejs.util.UtilsJS;
import dev.latvian.mods.rhino.type.EnumTypeInfo;
import dev.latvian.mods.rhino.type.TypeInfo;
import java.util.function.Predicate;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class EventTargetType<T> {
    public static final EventTargetType<String> STRING = EventTargetType.create(String.class).transformer(EventTargetType::toString);
    public static final EventTargetType<ResourceLocation> ID = EventTargetType.create(ResourceLocation.class).transformer(EventTargetType::toResourceLocation);
    public static final EventTargetType<ResourceKey<Registry<?>>> REGISTRY = (EventTargetType)Cast.to(EventTargetType.create(ResourceKey.class).transformer(EventTargetType::toRegistryKey).identity());
    public final Class<T> type;
    public Transformer transformer;
    public boolean identity;
    public Predicate<Object> validator;
    public Transformer toString;
    public TypeInfo describeType;

    public static <T> EventTargetType<T> create(Class<T> type) {
        return new EventTargetType<T>(type);
    }

    public static <T> EventTargetType<ResourceKey<T>> registryKey(ResourceKey<Registry<T>> registry, Class<?> type) {
        return (EventTargetType)Cast.to(EventTargetType.create(ResourceKey.class).identity().transformer(o -> EventTargetType.toKey(registry, o)).describeType(TypeInfo.of(ResourceKey.class).withParams(new TypeInfo[]{TypeInfo.of(type)})));
    }

    public static <T extends Enum<T>> EventTargetType<T> fromEnum(Class<T> type) {
        EnumTypeInfo typeInfo = (EnumTypeInfo)TypeInfo.of(type);
        return EventTargetType.create(type).transformer(o -> {
            if (o == null) {
                return null;
            }
            if (type.isInstance(o)) {
                return o;
            }
            if (o instanceof CharSequence) {
                String s = o.toString();
                if (s.isEmpty()) {
                    return null;
                }
                for (Object entry : typeInfo.enumConstants()) {
                    if (!EnumTypeInfo.getName(entry).equalsIgnoreCase(s)) continue;
                    return entry;
                }
                return null;
            }
            return null;
        });
    }

    private static String toString(Object object) {
        if (object == null) {
            return null;
        }
        String s = object.toString();
        return s.isBlank() ? null : s;
    }

    private static ResourceLocation toResourceLocation(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof ResourceLocation) {
            ResourceLocation rl = (ResourceLocation)object;
            return rl;
        }
        String s = object.toString();
        return s.isBlank() ? null : ResourceLocation.tryParse((String)s);
    }

    private static ResourceKey<?> toKey(ResourceKey registry, Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof ResourceKey) {
            ResourceKey rl = (ResourceKey)object;
            return rl;
        }
        if (object instanceof RegistryObjectKJS) {
            RegistryObjectKJS wrk = (RegistryObjectKJS)object;
            return wrk.kjs$getRegistryKey();
        }
        if (object instanceof ResourceLocation) {
            ResourceLocation rl = (ResourceLocation)object;
            return ResourceKey.create((ResourceKey)registry, (ResourceLocation)rl);
        }
        String s = object.toString();
        return s.isBlank() ? null : ResourceKey.create((ResourceKey)registry, (ResourceLocation)ResourceLocation.parse((String)s));
    }

    private static ResourceKey<? extends Registry<?>> toRegistryKey(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof ResourceKey) {
            ResourceKey rl = (ResourceKey)object;
            return rl;
        }
        if (object instanceof ResourceLocation) {
            ResourceLocation rl = (ResourceLocation)object;
            return ResourceKey.createRegistryKey((ResourceLocation)rl);
        }
        String s = object.toString();
        return s.isBlank() ? null : ResourceKey.createRegistryKey((ResourceLocation)ResourceLocation.parse((String)s));
    }

    private EventTargetType(Class<T> type) {
        this.type = type;
        this.transformer = Transformer.IDENTITY;
        this.identity = false;
        this.validator = UtilsJS.ALWAYS_TRUE;
        this.toString = Transformer.IDENTITY;
        this.describeType = TypeInfo.STRING;
    }

    public EventTargetType<T> transformer(Transformer factory) {
        this.transformer = factory;
        return this;
    }

    public EventTargetType<T> identity() {
        this.identity = true;
        return this;
    }

    public EventTargetType<T> validator(Predicate<Object> validator) {
        this.validator = validator;
        return this;
    }

    public EventTargetType<T> describeType(TypeInfo describeType) {
        this.describeType = describeType;
        return this;
    }

    public EventTargetType<T> toString(Transformer factory) {
        this.toString = factory;
        return this;
    }

    @FunctionalInterface
    public static interface Transformer {
        public static final Transformer IDENTITY = o -> o;

        @Nullable
        public Object transform(Object var1);
    }
}

