/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.entity;

import com.mojang.datafixers.util.Either;
import dev.latvian.mods.kubejs.bindings.event.EntityEvents;
import dev.latvian.mods.kubejs.entity.AfterLivingEntityHurtKubeEvent;
import dev.latvian.mods.kubejs.entity.BeforeLivingEntityHurtKubeEvent;
import dev.latvian.mods.kubejs.entity.CheckLivingEntitySpawnKubeEvent;
import dev.latvian.mods.kubejs.entity.EntitySpawnedKubeEvent;
import dev.latvian.mods.kubejs.entity.LivingEntityDeathKubeEvent;
import dev.latvian.mods.kubejs.entity.LivingEntityDropsKubeEvent;
import dev.latvian.mods.kubejs.event.EventResult;
import dev.latvian.mods.kubejs.script.ScriptTypeHolder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.bus.api.ICancellableEvent;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.living.FinalizeSpawnEvent;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.living.LivingDropsEvent;

@EventBusSubscriber(modid="kubejs")
public class KubeJSEntityEventHandler {
    @SubscribeEvent
    public static void checkSpawn(FinalizeSpawnEvent event) {
        ResourceKey key = event.getEntity().getType().kjs$getRegistryKey();
        ServerLevelAccessor serverLevelAccessor = event.getLevel();
        if (serverLevelAccessor instanceof ServerLevel) {
            EventResult result;
            ServerLevel level = (ServerLevel)serverLevelAccessor;
            if (EntityEvents.CHECK_SPAWN.hasListeners(key) && ((result = EntityEvents.CHECK_SPAWN.post((ScriptTypeHolder)level, key, new CheckLivingEntitySpawnKubeEvent((LivingEntity)event.getEntity(), (Level)level, event.getX(), event.getY(), event.getZ(), event.getSpawnType(), (Either<BlockEntity, Entity>)event.getSpawner()))).interruptFalse() || result.interruptTrue())) {
                event.setSpawnCancelled(result.interruptFalse());
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void livingDeath(LivingDeathEvent event) {
        ResourceKey key = event.getEntity().getType().kjs$getRegistryKey();
        if (EntityEvents.DEATH.hasListeners(key)) {
            EntityEvents.DEATH.post((ScriptTypeHolder)event.getEntity(), key, new LivingEntityDeathKubeEvent(event.getEntity(), event.getSource())).applyCancel((ICancellableEvent)event);
        }
    }

    @SubscribeEvent
    public static void beforeLivingHurt(LivingDamageEvent.Pre event) {
        ResourceKey key = event.getEntity().getType().kjs$getRegistryKey();
        if (EntityEvents.BEFORE_HURT.hasListeners(key) && EntityEvents.BEFORE_HURT.post((ScriptTypeHolder)event.getEntity(), key, new BeforeLivingEntityHurtKubeEvent(event)).interruptFalse()) {
            event.getContainer().setNewDamage(0.0f);
        }
    }

    @SubscribeEvent
    public static void afterLivingHurt(LivingDamageEvent.Post event) {
        ResourceKey key = event.getEntity().getType().kjs$getRegistryKey();
        if (EntityEvents.AFTER_HURT.hasListeners(key)) {
            EntityEvents.AFTER_HURT.post((ScriptTypeHolder)event.getEntity(), key, new AfterLivingEntityHurtKubeEvent(event));
        }
    }

    @SubscribeEvent
    public static void entitySpawned(EntityJoinLevelEvent event) {
        Level level;
        ResourceKey key = event.getEntity().getType().kjs$getRegistryKey();
        if (EntityEvents.SPAWNED.hasListeners(key) && (level = event.getLevel()) instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            EntityEvents.SPAWNED.post((ScriptTypeHolder)level2, key, new EntitySpawnedKubeEvent(event.getEntity(), (Level)level2)).applyCancel((ICancellableEvent)event);
        }
    }

    @SubscribeEvent
    public static void livingDrops(LivingDropsEvent event) {
        ResourceKey key = event.getEntity().getType().kjs$getRegistryKey();
        if (EntityEvents.ENTITY_DROPS.hasListeners(key)) {
            LivingEntityDropsKubeEvent e = new LivingEntityDropsKubeEvent(event);
            if (!EntityEvents.ENTITY_DROPS.post((ScriptTypeHolder)event.getEntity(), key, e).applyCancel((ICancellableEvent)event) && e.eventDrops != null) {
                event.getDrops().clear();
                event.getDrops().addAll(e.eventDrops);
            }
        }
    }
}

