/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.entity;

import dev.latvian.mods.kubejs.registry.RegistryInfo;
import java.util.Collection;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.Nullable;

public class EntityPotionEffectsJS {
    private final LivingEntity entity;

    public EntityPotionEffectsJS(LivingEntity e) {
        this.entity = e;
    }

    public void clear() {
        this.entity.removeAllEffects();
    }

    public Collection<MobEffectInstance> getActive() {
        return this.entity.getActiveEffects();
    }

    public Map<Holder<MobEffect>, MobEffectInstance> getMap() {
        return this.entity.getActiveEffectsMap();
    }

    public boolean isHolderActive(Holder<MobEffect> mobEffect) {
        return mobEffect != null && this.entity.hasEffect(mobEffect);
    }

    public boolean isActive(MobEffect mobEffect) {
        return this.isHolderActive(RegistryInfo.MOB_EFFECT.getHolderOf(mobEffect));
    }

    public int getDuration(MobEffect mobEffect) {
        return this.getHolderDuration(RegistryInfo.MOB_EFFECT.getHolderOf(mobEffect));
    }

    public int getHolderDuration(Holder<MobEffect> mobEffect) {
        MobEffectInstance i = this.entity.getEffect(mobEffect);
        return i == null ? 0 : i.getDuration();
    }

    @Nullable
    public MobEffectInstance getActive(MobEffect mobEffect) {
        return this.getHolderActive(RegistryInfo.MOB_EFFECT.getHolderOf(mobEffect));
    }

    @Nullable
    public MobEffectInstance getHolderActive(Holder<MobEffect> mobEffect) {
        return mobEffect == null ? null : this.entity.getEffect(mobEffect);
    }

    public void add(MobEffect mobEffect) {
        this.add(mobEffect, 200);
    }

    public void add(MobEffect mobEffect, int duration) {
        this.add(mobEffect, duration, 0);
    }

    public void add(MobEffect mobEffect, int duration, int amplifier) {
        this.add(mobEffect, duration, amplifier, false, true);
    }

    public void add(MobEffect mobEffect, int duration, int amplifier, boolean ambient, boolean showParticles) {
        if (mobEffect != null) {
            this.entity.addEffect(new MobEffectInstance(RegistryInfo.MOB_EFFECT.getHolderOf(mobEffect), duration, amplifier, ambient, showParticles));
        }
    }

    public boolean isApplicable(MobEffectInstance effect) {
        return this.entity.canBeAffected(effect);
    }
}

