/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.core;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import dev.latvian.mods.kubejs.bindings.event.ServerEvents;
import dev.latvian.mods.kubejs.core.ReloadableServerResourcesKJS;
import dev.latvian.mods.kubejs.registry.BuilderBase;
import dev.latvian.mods.kubejs.registry.RegistryInfo;
import dev.latvian.mods.kubejs.script.ConsoleJS;
import dev.latvian.mods.kubejs.server.DataExport;
import dev.latvian.mods.kubejs.server.tag.PreTagKubeEvent;
import dev.latvian.mods.kubejs.server.tag.TagEventFilter;
import dev.latvian.mods.kubejs.server.tag.TagKubeEvent;
import dev.latvian.mods.kubejs.server.tag.TagWrapper;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagLoader;
import org.jetbrains.annotations.Nullable;

public interface TagLoaderKJS<T> {
    default public void kjs$customTags(ReloadableServerResourcesKJS kjs$resources, Map<ResourceLocation, List<TagLoader.EntryWithSource>> map) {
        Registry<T> reg = this.kjs$getRegistry();
        if (reg == null) {
            return;
        }
        RegistryInfo regInfo = RegistryInfo.of(reg.key());
        if (regInfo.hasDefaultTags || ServerEvents.TAGS.hasListeners(regInfo.key)) {
            PreTagKubeEvent preEvent = this.kjs$getResources().kjs$getServerScriptManager().preTagEvents.get(reg.key());
            TagKubeEvent event = new TagKubeEvent(regInfo, reg);
            for (Map.Entry<ResourceLocation, List<TagLoader.EntryWithSource>> entry : map.entrySet()) {
                Iterator<ResourceLocation> w = new TagWrapper(event, entry.getKey(), entry.getValue());
                event.tags.put(((TagWrapper)((Object)w)).id, (TagWrapper)((Object)w));
                if (!ConsoleJS.SERVER.shouldPrintDebug()) continue;
                ConsoleJS.SERVER.debug("Tags %s/#%s; %d".formatted(regInfo, ((TagWrapper)((Object)w)).id, ((TagWrapper)((Object)w)).entries.size()));
            }
            for (BuilderBase builderBase : regInfo.objects.values()) {
                for (ResourceLocation s : builderBase.defaultTags) {
                    event.add(s, new TagEventFilter.ID(builderBase.id));
                }
            }
            if (preEvent == null) {
                ServerEvents.TAGS.post(event, regInfo.key);
            } else {
                for (Consumer consumer : preEvent.actions) {
                    consumer.accept(event);
                }
            }
            map.clear();
            for (Map.Entry entry : event.tags.entrySet()) {
                map.put((ResourceLocation)entry.getKey(), ((TagWrapper)entry.getValue()).entries);
            }
            if (event.totalAdded > 0 || event.totalRemoved > 0 || ConsoleJS.SERVER.shouldPrintDebug()) {
                ConsoleJS.SERVER.info("[%s] Found %d tags, added %d objects, removed %d objects".formatted(regInfo, event.tags.size(), event.totalAdded, event.totalRemoved));
            }
            kjs$resources.kjs$getServerScriptManager().getRegistries().cacheTags(reg, map);
        }
        if (DataExport.export != null) {
            String loc = "tags/" + String.valueOf(regInfo) + "/";
            for (Map.Entry<ResourceLocation, List<TagLoader.EntryWithSource>> entry : map.entrySet()) {
                ArrayList<String> arrayList = new ArrayList<String>();
                for (TagLoader.EntryWithSource e : entry.getValue()) {
                    arrayList.add(e.entry().toString());
                }
                arrayList.sort(String.CASE_INSENSITIVE_ORDER);
                JsonArray arr = new JsonArray();
                for (String e : arrayList) {
                    arr.add(e);
                }
                DataExport.export.addJson(loc + String.valueOf(entry.getKey()) + ".json", (JsonElement)arr);
            }
        }
    }

    public void kjs$init(ReloadableServerResourcesKJS var1, Registry<T> var2);

    public ReloadableServerResourcesKJS kjs$getResources();

    @Nullable
    public Registry<T> kjs$getRegistry();
}

